/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso;

import com.tc.aspectwerkz.reflect.ClassInfo;
import com.tc.aspectwerkz.reflect.FieldInfo;
import com.tc.aspectwerkz.reflect.MethodInfo;
import com.tc.aspectwerkz.reflect.impl.java.JavaClassInfo;
import com.tc.object.bytecode.aspectwerkz.ClassInfoFactory;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.terracotta.dso.JavaModelClassInfo;

public class ClassInformationFactory
extends ClassInfoFactory {
    private final Map<String, SoftReference> fClassInfoCache = new HashMap<String, SoftReference>();
    private static final ClassInfo intClassInfo = JavaClassInfo.getClassInfo(Integer.TYPE);
    private static final ClassInfo doubleClassInfo = JavaClassInfo.getClassInfo(Double.TYPE);
    private static final ClassInfo floatClassInfo = JavaClassInfo.getClassInfo(Float.TYPE);
    private static final ClassInfo longClassInfo = JavaClassInfo.getClassInfo(Long.TYPE);
    private static final ClassInfo charClassInfo = JavaClassInfo.getClassInfo(Character.TYPE);
    private static final ClassInfo byteClassInfo = JavaClassInfo.getClassInfo(Byte.TYPE);

    public ClassInformationFactory() {
        this.fClassInfoCache.put("int", new SoftReference<ClassInfo>(intClassInfo));
        this.fClassInfoCache.put("double", new SoftReference<ClassInfo>(doubleClassInfo));
        this.fClassInfoCache.put("float", new SoftReference<ClassInfo>(floatClassInfo));
        this.fClassInfoCache.put("long", new SoftReference<ClassInfo>(longClassInfo));
        this.fClassInfoCache.put("char", new SoftReference<ClassInfo>(charClassInfo));
        this.fClassInfoCache.put("byte", new SoftReference<ClassInfo>(byteClassInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassInfo getClassInfo(String className) {
        Object info = null;
        Map<String, SoftReference> map = this.fClassInfoCache;
        synchronized (map) {
            SoftReference ref = this.fClassInfoCache.get(className);
            if (ref != null) {
                info = (ClassInfo)ref.get();
            }
            if (info == null) {
                info = new JavaModelClassInfo(className);
                this.fClassInfoCache.put(className, new SoftReference<ClassInfo>((ClassInfo)info));
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassInfo getClassInfo(IType type) {
        if (type == null) {
            return null;
        }
        JavaModelClassInfo info = null;
        Map<String, SoftReference> map = this.fClassInfoCache;
        synchronized (map) {
            String className = type.getFullyQualifiedName('$');
            SoftReference ref = this.fClassInfoCache.get(className);
            if (ref != null) {
                info = (JavaModelClassInfo)((Object)ref.get());
            }
            if (info == null || info.isStale(type)) {
                info = new JavaModelClassInfo(type);
                this.fClassInfoCache.put(className, new SoftReference<JavaModelClassInfo>(info));
            }
        }
        return info;
    }

    public void clear(IType type) {
        if (type != null) {
            this.clear(type.getFullyQualifiedName('$'));
        }
    }

    public void clear(String className) {
        this.fClassInfoCache.remove(className);
    }

    public MethodInfo getMethodInfo(IMethod method) throws JavaModelException {
        JavaModelClassInfo classInfo = (JavaModelClassInfo)this.getClassInfo(method.getDeclaringType());
        return classInfo.getMethod(this, method);
    }

    public FieldInfo getFieldInfo(IField field) {
        JavaModelClassInfo classInfo = (JavaModelClassInfo)this.getClassInfo(field.getDeclaringType());
        return classInfo.getField(this, field);
    }
}

