/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.server.api;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.terracotta.dynamic_config.api.model.Configuration;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.server.api.ConfigChangeHandler;
import org.terracotta.dynamic_config.server.api.InvalidConfigChangeException;

public class SelectingConfigChangeHandler<T>
implements ConfigChangeHandler {
    private final Map<T, ConfigChangeHandler> handlers = new ConcurrentHashMap<T, ConfigChangeHandler>();
    private Function<Configuration, T> selector = change -> null;
    private ConfigChangeHandler fallback = ConfigChangeHandler.reject("Change rejected");

    public SelectingConfigChangeHandler<T> add(T key, ConfigChangeHandler handler) {
        this.handlers.put(Objects.requireNonNull(key), Objects.requireNonNull(handler));
        return this;
    }

    public SelectingConfigChangeHandler<T> fallback(ConfigChangeHandler handler) {
        this.fallback = Objects.requireNonNull(handler);
        return this;
    }

    public SelectingConfigChangeHandler<T> selector(Function<Configuration, T> selector) {
        this.selector = Objects.requireNonNull(selector);
        return this;
    }

    @Override
    public void validate(NodeContext baseConfig, Configuration change) throws InvalidConfigChangeException {
        T key = this.selector.apply(change);
        if (key != null) {
            ConfigChangeHandler handler = this.handlers.get(key);
            if (handler != null) {
                handler.validate(baseConfig, change);
            } else {
                this.fallback.validate(baseConfig, change);
            }
        } else {
            this.fallback.validate(baseConfig, change);
        }
    }

    @Override
    public void apply(Configuration change) {
        T key = this.selector.apply(change);
        if (key != null) {
            ConfigChangeHandler handler = this.handlers.get(key);
            if (handler != null) {
                handler.apply(change);
            } else {
                this.fallback.apply(change);
            }
        } else {
            this.fallback.apply(change);
        }
    }
}

