/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.service;

import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import org.terracotta.nomad.client.change.NomadChange;
import org.terracotta.nomad.messages.CommitMessage;
import org.terracotta.nomad.messages.PrepareMessage;
import org.terracotta.nomad.messages.RollbackMessage;
import org.terracotta.nomad.server.ChangeRequestState;

public class NomadChangeInfo {
    private final UUID changeUuid;
    private final NomadChange nomadChange;
    private final ChangeRequestState changeRequestState;
    private final long version;
    private final String creationHost;
    private final String creationUser;
    private final Instant creationTimestamp;
    private final String changeResultHash;

    public NomadChangeInfo(UUID changeUuid, NomadChange nomadChange, ChangeRequestState changeRequestState, long version, String creationHost, String creationUser, Instant creationTimestamp, String changeResultHash) {
        this.changeUuid = changeUuid;
        this.nomadChange = nomadChange;
        this.changeRequestState = changeRequestState;
        this.version = version;
        this.creationHost = creationHost;
        this.creationUser = creationUser;
        this.creationTimestamp = creationTimestamp;
        this.changeResultHash = changeResultHash;
    }

    public String getChangeResultHash() {
        return this.changeResultHash;
    }

    public Instant getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public UUID getChangeUuid() {
        return this.changeUuid;
    }

    public NomadChange getNomadChange() {
        return this.nomadChange;
    }

    public ChangeRequestState getChangeRequestState() {
        return this.changeRequestState;
    }

    public String getCreationHost() {
        return this.creationHost;
    }

    public String getCreationUser() {
        return this.creationUser;
    }

    public long getVersion() {
        return this.version;
    }

    public String toString() {
        return "Change{uuid=" + this.changeUuid + ",hash=" + this.changeResultHash + ",state=" + this.changeRequestState + ",summary=" + this.nomadChange.getSummary() + '}';
    }

    public boolean matches(NomadChangeInfo other) {
        return Objects.equals(this.changeUuid, other.changeUuid) || Objects.equals(this.changeResultHash, other.changeResultHash) && Objects.equals(this.nomadChange, other.nomadChange);
    }

    public PrepareMessage toPrepareMessage(long mutativeMessageCount) {
        return new PrepareMessage(mutativeMessageCount, this.getCreationHost(), this.getCreationUser(), this.getCreationTimestamp(), this.getChangeUuid(), this.getVersion(), this.getNomadChange());
    }

    public CommitMessage toCommitMessage(long mutativeMessageCount) {
        return new CommitMessage(mutativeMessageCount, this.getCreationHost(), this.getCreationUser(), this.getCreationTimestamp(), this.getChangeUuid());
    }

    public RollbackMessage toRollbackMessage(long mutativeMessageCount) {
        return new RollbackMessage(mutativeMessageCount, this.getCreationHost(), this.getCreationUser(), this.getCreationTimestamp(), this.getChangeUuid());
    }
}

