/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.service;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.terracotta.diagnostic.model.LogicalServerState;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.LockContext;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.OptionalConfig;
import org.terracotta.dynamic_config.api.service.ConfigurationConsistencyState;
import org.terracotta.inet.HostPort;
import org.terracotta.nomad.client.recovery.RecoveryProcessDecider;
import org.terracotta.nomad.client.results.DiscoverResultsReceiver;
import org.terracotta.nomad.messages.ChangeDetails;
import org.terracotta.nomad.messages.DiscoverResponse;
import org.terracotta.nomad.server.NomadServerMode;

public class ConfigurationConsistencyAnalyzer
implements DiscoverResultsReceiver<NodeContext> {
    private final Map<HostPort, DiscoverResponse<NodeContext>> responses;
    private final Map<HostPort, LogicalServerState> allNodes;
    private final RecoveryProcessDecider<NodeContext> recoveryProcessDecider;
    private volatile Throwable discoverFailure;
    private volatile boolean discoveredConfigInconsistent;
    private volatile boolean discoveredOtherClient;
    private volatile UUID inconsistentChangeUuid;
    private volatile Collection<HostPort> committedNodes;
    private volatile Collection<HostPort> rolledBackNodes;
    private volatile boolean discoveredConfigPartitioned;
    private volatile Collection<Collection<HostPort>> partitions;
    private volatile HostPort nodeProcessingOtherClient;
    private volatile String otherClientHost;
    private volatile String otherClientUser;

    public ConfigurationConsistencyAnalyzer(Map<HostPort, LogicalServerState> allNodes) {
        this.allNodes = allNodes;
        this.responses = new LinkedHashMap<HostPort, DiscoverResponse<NodeContext>>(allNodes.size());
        this.recoveryProcessDecider = new RecoveryProcessDecider(allNodes.size(), null);
    }

    public void discovered(HostPort nodeAddress, DiscoverResponse<NodeContext> discovery) {
        this.recoveryProcessDecider.discovered(nodeAddress, discovery);
        this.responses.put(nodeAddress, discovery);
    }

    public void discoverFail(HostPort server, Throwable reason) {
        this.recoveryProcessDecider.discoverFail(server, reason);
        this.discoverFailure = reason;
    }

    public void discoverConfigInconsistent(UUID changeUuid, Collection<HostPort> committedServers, Collection<HostPort> rolledBackServers) {
        this.recoveryProcessDecider.discoverConfigInconsistent(changeUuid, committedServers, rolledBackServers);
        this.inconsistentChangeUuid = changeUuid;
        this.committedNodes = committedServers;
        this.rolledBackNodes = rolledBackServers;
        this.discoveredConfigInconsistent = true;
    }

    public void discoverConfigPartitioned(Collection<Collection<HostPort>> partitions) {
        this.recoveryProcessDecider.discoverConfigPartitioned(partitions);
        this.discoveredConfigPartitioned = true;
        this.partitions = partitions;
    }

    public void discoverOtherClient(HostPort nodeAddress, String lastMutationHost, String lastMutationUser) {
        this.recoveryProcessDecider.discoverOtherClient(nodeAddress, lastMutationHost, lastMutationUser);
        this.nodeProcessingOtherClient = nodeAddress;
        this.otherClientHost = lastMutationHost;
        this.otherClientUser = lastMutationUser;
        this.discoveredOtherClient = true;
    }

    public int getNodeCount() {
        return this.allNodes.size();
    }

    public Map<HostPort, LogicalServerState> getAllNodes() {
        return this.allNodes;
    }

    public LogicalServerState getState(HostPort endpoint) {
        return this.allNodes.get(endpoint);
    }

    public Optional<DiscoverResponse<NodeContext>> getDiscoveryResponse(HostPort endpoint) {
        return Optional.ofNullable(this.responses.get(endpoint));
    }

    public Optional<Throwable> getDiscoverFailure() {
        return Optional.ofNullable(this.discoverFailure);
    }

    public UUID getInconsistentChangeUuid() {
        return this.inconsistentChangeUuid;
    }

    public Collection<HostPort> getCommittedNodes() {
        return this.committedNodes;
    }

    public Collection<HostPort> getRolledBackNodes() {
        return this.rolledBackNodes;
    }

    public Collection<Collection<HostPort>> getPartitions() {
        return this.partitions;
    }

    public HostPort getNodeProcessingOtherClient() {
        return this.nodeProcessingOtherClient;
    }

    public String getOtherClientHost() {
        return this.otherClientHost;
    }

    public String getOtherClientUser() {
        return this.otherClientUser;
    }

    public int getOnlineNodeCount() {
        return this.responses.size();
    }

    public Map<HostPort, LogicalServerState> getOnlineNodes() {
        return this.responses.entrySet().stream().collect(this.responseEntryToMap());
    }

    public Map<HostPort, LogicalServerState> getOnlineNodesActivated() {
        return this.responses.entrySet().stream().filter(e -> this.allNodes.get(e.getKey()) != LogicalServerState.DIAGNOSTIC && ((DiscoverResponse)e.getValue()).getLatestChange() != null).collect(this.responseEntryToMap());
    }

    public Map<HostPort, LogicalServerState> getOnlineNodesInRepair() {
        return this.responses.entrySet().stream().filter(e -> this.allNodes.get(e.getKey()) == LogicalServerState.DIAGNOSTIC && ((DiscoverResponse)e.getValue()).getLatestChange() != null).collect(this.responseEntryToMap());
    }

    public Map<HostPort, LogicalServerState> getOnlineNodesInConfiguration() {
        return this.responses.entrySet().stream().filter(e -> this.allNodes.get(e.getKey()) == LogicalServerState.DIAGNOSTIC && ((DiscoverResponse)e.getValue()).getLatestChange() == null).collect(this.responseEntryToMap());
    }

    public ConfigurationConsistencyState getState() {
        if (this.discoverFailure != null) {
            return ConfigurationConsistencyState.DISCOVERY_FAILURE;
        }
        if (this.discoveredConfigInconsistent) {
            return ConfigurationConsistencyState.INCONSISTENT;
        }
        if (this.discoveredConfigPartitioned) {
            return ConfigurationConsistencyState.PARTITIONED;
        }
        if (this.discoveredOtherClient) {
            return ConfigurationConsistencyState.CHANGE_IN_PROGRESS;
        }
        int onlineNodeCount = this.getOnlineNodeCount();
        int totalNodeCount = this.getNodeCount();
        boolean areAllAccepting = this.responses.values().stream().map(DiscoverResponse::getMode).allMatch(Predicate.isEqual(NomadServerMode.ACCEPTING));
        if (areAllAccepting) {
            return onlineNodeCount >= totalNodeCount ? ConfigurationConsistencyState.ALL_ACCEPTING : ConfigurationConsistencyState.ONLINE_ACCEPTING;
        }
        boolean areAllPrepared = this.responses.values().stream().map(DiscoverResponse::getMode).allMatch(Predicate.isEqual(NomadServerMode.PREPARED));
        if (areAllPrepared) {
            return onlineNodeCount >= totalNodeCount ? ConfigurationConsistencyState.ALL_PREPARED : ConfigurationConsistencyState.ONLINE_PREPARED;
        }
        boolean areAllUninitialized = this.responses.values().stream().map(DiscoverResponse::getMode).allMatch(Predicate.isEqual(NomadServerMode.UNINITIALIZED));
        if (areAllUninitialized) {
            return onlineNodeCount >= totalNodeCount ? ConfigurationConsistencyState.ALL_UNINITIALIZED : ConfigurationConsistencyState.ONLINE_UNINITIALIZED;
        }
        if (this.recoveryProcessDecider.partiallyPrepared()) {
            return ConfigurationConsistencyState.PARTIALLY_PREPARED;
        }
        if (this.recoveryProcessDecider.partiallyRolledBack()) {
            return ConfigurationConsistencyState.PARTIALLY_ROLLED_BACK;
        }
        if (this.recoveryProcessDecider.partiallyCommitted()) {
            return ConfigurationConsistencyState.PARTIALLY_COMMITTED;
        }
        return ConfigurationConsistencyState.UNKNOWN;
    }

    public String getDescription() {
        ConfigurationConsistencyState state = this.getState();
        switch (state) {
            case ALL_ACCEPTING: {
                return "The cluster configuration is healthy and all nodes are online. No repair needed. " + this.getLockingInfo();
            }
            case ONLINE_ACCEPTING: {
                return "The cluster configuration seems healthy (some nodes are unreachable). " + this.getLockingInfo();
            }
            case DISCOVERY_FAILURE: {
                return "Failed to analyze cluster configuration." + this.getDiscoverFailure().map(Throwable::getMessage).map(msg -> " Reason: " + msg).orElse("");
            }
            case CHANGE_IN_PROGRESS: {
                return "Failed to analyze cluster configuration. Reason: a change is in progress: Host: " + this.getOtherClientHost() + ", By: " + this.getOtherClientUser() + ", On: " + this.getNodeProcessingOtherClient();
            }
            case INCONSISTENT: {
                return "Cluster configuration is inconsistent: Change " + this.getInconsistentChangeUuid() + " is committed on " + ConfigurationConsistencyAnalyzer.toString(this.getCommittedNodes()) + " and rolled back on " + ConfigurationConsistencyAnalyzer.toString(this.getRolledBackNodes());
            }
            case PARTITIONED: {
                return "Cluster configuration is partitioned and cannot be automatically repaired. Some nodes have a different configuration that others. Groups: | " + this.getPartitions().stream().map(ConfigurationConsistencyAnalyzer::toString).collect(Collectors.joining(" | ")) + " |";
            }
            case ALL_PREPARED: {
                return "A new cluster configuration has been prepared on all nodes but not yet committed. No further configuration change can be done until the 'repair' command is run to finalize the configuration change.";
            }
            case ONLINE_PREPARED: {
                return "A new cluster configuration has been prepared but not yet committed or rolled back on online nodes. Some nodes are unreachable so we do not know if the last configuration change has been committed or rolled back on them. No further configuration change can be done until the offline nodes are restarted and the 'repair' command is run again to finalize the configuration change. Please refer to the Troubleshooting Guide if needed.";
            }
            case ALL_UNINITIALIZED: {
                return "All the nodes are being configured (or being repaired).";
            }
            case ONLINE_UNINITIALIZED: {
                return "All the online nodes are being configured (or being repaired).";
            }
            case PARTIALLY_PREPARED: {
                return "A new  cluster configuration has been *partially* prepared (some nodes didn't get the new change). No further configuration change can be done until the 'repair' command is run to rollback the prepared nodes.";
            }
            case PARTIALLY_COMMITTED: {
                return "A new  cluster configuration has been *partially* committed (some nodes didn't commit). No further configuration change can be done until the 'repair' command is run to commit all nodes.";
            }
            case PARTIALLY_ROLLED_BACK: {
                return "A new  cluster configuration has been *partially* rolled back (some nodes didn't rollback). No further configuration change can be done until the 'repair' command is run to rollback all nodes.";
            }
            case UNKNOWN: {
                return "Unable to determine the global configuration state. There might be some configuration inconsistencies or some nodes being repaired. Please look at each node details. A manual intervention might be needed to reset some nodes.";
            }
        }
        throw new AssertionError((Object)state);
    }

    public Optional<LockContext> findLockContext() {
        return this.responses.values().stream().map(DiscoverResponse::getLatestChange).filter(Objects::nonNull).map(ChangeDetails::getResult).findAny().map(NodeContext::getCluster).map(Cluster::getConfigurationLockContext).flatMap(OptionalConfig::asOptional);
    }

    private String getLockingInfo() {
        return this.findLockContext().map(c -> String.format("No changes are possible as config is locked by '%s'.", c.ownerInfo())).orElse("New configuration changes are possible.");
    }

    public Optional<Cluster> findCluster() {
        return this.responses.values().stream().map(DiscoverResponse::getLatestChange).filter(Objects::nonNull).map(ChangeDetails::getResult).findAny().map(NodeContext::getCluster);
    }

    private Collector<Map.Entry<HostPort, DiscoverResponse<NodeContext>>, ?, LinkedHashMap<HostPort, LogicalServerState>> responseEntryToMap() {
        return Collectors.toMap(Map.Entry::getKey, e -> this.allNodes.getOrDefault(e.getKey(), LogicalServerState.UNKNOWN), (logicalServerState, logicalServerState2) -> {
            throw new UnsupportedOperationException();
        }, LinkedHashMap::new);
    }

    protected static String toString(Collection<?> items) {
        return items.stream().map(Object::toString).sorted().collect(Collectors.joining(", "));
    }
}

