/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model.nomad;

import java.util.Objects;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.nomad.StripeNomadChange;

public class StripeRemovalNomadChange
extends StripeNomadChange {
    public StripeRemovalNomadChange(Cluster cluster, Stripe stripe) {
        super(cluster, stripe);
    }

    @Override
    public Cluster apply(Cluster original) {
        Objects.requireNonNull(original);
        if (!original.getStripe(this.getStripe().getUID()).isPresent()) {
            throw new IllegalArgumentException("Stripe : " + this.getStripe() + " is not in cluster: " + original);
        }
        Cluster updated = original.clone();
        updated.removeStripe(this.getStripe().getUID());
        return updated;
    }

    @Override
    public boolean canUpdateRuntimeTopology(NodeContext nodeContext) {
        return true;
    }

    public String getSummary() {
        return "Detaching stripe: " + this.getStripe().getName() + " from cluster: " + this.getCluster().getName();
    }

    public String toString() {
        return "StripeRemovalChange{stripe=" + this.getStripe().toShapeString() + ", cluster=" + this.getCluster().toShapeString() + '}';
    }
}

