/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model.nomad;

import java.util.Objects;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.nomad.StripeNomadChange;

public class StripeAdditionNomadChange
extends StripeNomadChange {
    public StripeAdditionNomadChange(Cluster cluster, Stripe stripe) {
        super(cluster, stripe);
        if (cluster.getStripes().stream().noneMatch(arg_0 -> ((Stripe)stripe).equals(arg_0))) {
            throw new IllegalArgumentException("Stripe " + stripe.toShapeString() + " is not part of cluster " + cluster.toShapeString());
        }
    }

    @Override
    public Cluster apply(Cluster original) {
        Objects.requireNonNull(original);
        if (original.getStripes().contains(this.getStripe())) {
            throw new IllegalArgumentException("Stripe :" + this.getStripe() + " already exists in cluster: " + original);
        }
        Cluster updated = original.clone();
        updated.addStripe(this.getStripe().clone());
        return updated;
    }

    @Override
    public boolean canUpdateRuntimeTopology(NodeContext nodeContext) {
        return true;
    }

    public String getSummary() {
        return "Attaching stripe: " + this.getStripe().toShapeString() + " to cluster: " + this.getCluster().getName();
    }

    public String toString() {
        return "StripeAdditionChange{stripe=" + this.getStripe().toShapeString() + ", cluster=" + this.getCluster().toShapeString() + '}';
    }
}

