/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model.nomad;

import java.util.Objects;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.UID;
import org.terracotta.dynamic_config.api.model.nomad.NodeNomadChange;

public class NodeAdditionNomadChange
extends NodeNomadChange {
    public NodeAdditionNomadChange(Cluster cluster, UID stripeUID, Node node) {
        super(cluster, stripeUID, node);
        Stripe stripe = (Stripe)cluster.getStripe(stripeUID).orElseThrow(() -> new IllegalArgumentException("Invalid stripe UID: " + stripeUID + " in cluster " + cluster.toShapeString()));
        if (stripe.getNodes().stream().noneMatch(arg_0 -> ((Node)node).equals(arg_0))) {
            throw new IllegalArgumentException("Node " + node.getName() + " is not part of stripe: " + stripe.getName() + " in cluster " + cluster.toShapeString());
        }
    }

    @Override
    public Cluster apply(Cluster original) {
        Objects.requireNonNull(original);
        original.getStripe(this.getStripeUID()).orElseThrow(() -> new IllegalArgumentException("Stripe UID: " + this.getStripeUID() + " does not exist in cluster: " + original.toShapeString()));
        if (original.containsNode(this.getNode().getName())) {
            throw new IllegalArgumentException("Node name: " + this.getNode().getName() + " already exists in cluster: " + original.toShapeString());
        }
        if (original.containsNode(this.getNode().getUID())) {
            throw new IllegalArgumentException("Node: " + this.getNode().getUID() + " already exists in cluster: " + original);
        }
        Cluster updated = original.clone();
        ((Stripe)updated.getStripe(this.getStripeUID()).get()).addNode(this.getNode().clone());
        return updated;
    }

    @Override
    public boolean canUpdateRuntimeTopology(NodeContext currentNode) {
        return true;
    }

    public String getSummary() {
        return "Attaching node: " + this.getNode().toShapeString() + " to stripe: " + ((Stripe)this.getCluster().getStripe(this.getStripeUID()).get()).getName();
    }

    public String toString() {
        return "NodeAdditionNomadChange{stripeUID=" + this.getStripeUID() + ", node=" + this.getNode().getName() + ", cluster=" + this.getCluster().toShapeString() + '}';
    }
}

