/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model.nomad;

import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.Version;
import org.terracotta.dynamic_config.api.model.nomad.ClusterActivationNomadChange;

public class FormatUpgradeNomadChange
extends ClusterActivationNomadChange {
    private final Version from;
    private final Version to;

    public FormatUpgradeNomadChange(Version from, Version to, Cluster cluster) {
        super(cluster);
        this.from = from;
        this.to = to;
    }

    @Override
    public String getSummary() {
        return "Upgrading configuration format from version " + this.from + " to version " + this.to;
    }

    @Override
    public Cluster apply(Cluster original) {
        return this.getCluster();
    }

    @Override
    public boolean canUpdateRuntimeTopology(NodeContext currentNode) {
        return false;
    }

    public Version getFrom() {
        return this.from;
    }

    public Version getTo() {
        return this.to;
    }

    @Override
    public String toString() {
        return "FormatUpgradeNomadChange{from=" + this.from + ", to=" + this.to + ", cluster=" + this.getCluster().toShapeString() + '}';
    }
}

