/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model.nomad;

import java.util.Objects;
import java.util.Optional;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.UID;
import org.terracotta.dynamic_config.api.model.nomad.Applicability;

public class DefaultApplicability
implements Applicability {
    private final Scope level;
    private final UID nodeUID;
    private final UID stripeUID;

    public DefaultApplicability(Scope level, UID stripeUID, UID nodeUID) {
        this.level = Objects.requireNonNull(level);
        this.stripeUID = stripeUID;
        this.nodeUID = nodeUID;
    }

    @Override
    public Scope getLevel() {
        return this.level;
    }

    public UID getNodeUID() {
        return this.nodeUID;
    }

    public UID getStripeUID() {
        return this.stripeUID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Applicability && ((Applicability)o).getLevel() == Scope.CLUSTER && this.getLevel() == Scope.CLUSTER) {
            return true;
        }
        if (!(o instanceof DefaultApplicability)) {
            return false;
        }
        DefaultApplicability that = (DefaultApplicability)o;
        return this.getLevel() == that.getLevel() && Objects.equals(this.getNodeUID(), that.getNodeUID()) && Objects.equals(this.getStripeUID(), that.getStripeUID());
    }

    public int hashCode() {
        return Objects.hash(this.getLevel(), this.getNodeUID(), this.getStripeUID());
    }

    public String toString() {
        switch (this.getLevel()) {
            case STRIPE: {
                return "stripe UID: " + this.getStripeUID();
            }
            case NODE: {
                return "node UID: " + this.getNodeUID();
            }
        }
        return "cluster";
    }

    @Override
    public Optional<Stripe> getStripe(Cluster cluster) {
        switch (this.level) {
            case CLUSTER: {
                throw new UnsupportedOperationException("level: " + this.level);
            }
            case STRIPE: {
                return cluster.getStripe(this.stripeUID);
            }
            case NODE: {
                return cluster.getStripeByNode(this.nodeUID);
            }
        }
        throw new AssertionError(this.level);
    }

    @Override
    public Optional<Node> getNode(Cluster cluster) {
        if (this.level != Scope.NODE) {
            // empty if block
        }
        return cluster.getNode(this.getNodeUID());
    }

    @Override
    public boolean isApplicableTo(NodeContext node) {
        switch (this.getLevel()) {
            case CLUSTER: {
                return true;
            }
            case STRIPE: {
                return this.getStripeUID().equals((Object)node.getStripeUID());
            }
            case NODE: {
                return this.getNodeUID().equals((Object)node.getNodeUID());
            }
        }
        throw new AssertionError(this.getLevel());
    }
}

