/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model.nomad;

import java.util.Objects;
import java.util.Optional;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.UID;
import org.terracotta.dynamic_config.api.model.nomad.DefaultApplicability;

public interface Applicability {
    public static Applicability cluster() {
        return new DefaultApplicability(Scope.CLUSTER, null, null);
    }

    public static Applicability stripe(UID stripeUID) {
        return new DefaultApplicability(Scope.STRIPE, Objects.requireNonNull(stripeUID), null);
    }

    public static Applicability node(UID nodeUID) {
        return new DefaultApplicability(Scope.NODE, null, Objects.requireNonNull(nodeUID));
    }

    public Scope getLevel();

    public Optional<Stripe> getStripe(Cluster var1);

    public Optional<Node> getNode(Cluster var1);

    public boolean isApplicableTo(NodeContext var1);
}

