/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.json;

import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.nomad.Applicability;

@Deprecated
public class ApplicabilityV1
implements Applicability {
    private final Scope scope;
    private final String nodeName;
    private final Integer stripeId;

    public ApplicabilityV1(Scope level, Integer stripeId, String nodeName) {
        this.scope = Objects.requireNonNull(level);
        this.stripeId = stripeId;
        this.nodeName = nodeName;
    }

    @Override
    public Scope getLevel() {
        return this.scope;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public OptionalInt getStripeId() {
        return this.stripeId == null ? OptionalInt.empty() : OptionalInt.of(this.stripeId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Applicability && ((Applicability)o).getLevel() == Scope.CLUSTER && this.getLevel() == Scope.CLUSTER) {
            return true;
        }
        if (!(o instanceof ApplicabilityV1)) {
            return false;
        }
        ApplicabilityV1 that = (ApplicabilityV1)o;
        return this.getLevel() == that.getLevel() && Objects.equals(this.getNodeName(), that.getNodeName()) && Objects.equals(this.getStripeId(), that.getStripeId());
    }

    public int hashCode() {
        return Objects.hash(this.getLevel(), this.getNodeName(), this.getStripeId());
    }

    public String toString() {
        switch (this.getLevel()) {
            case STRIPE: {
                return "stripe ID: " + this.getStripeId().getAsInt();
            }
            case NODE: {
                return "stripe ID: " + this.getStripeId().getAsInt() + ", node: " + this.getNodeName();
            }
        }
        return "cluster";
    }

    @Override
    public Optional<Stripe> getStripe(Cluster cluster) {
        return cluster.getStripe(this.getStripeId().getAsInt());
    }

    @Override
    public Optional<Node> getNode(Cluster cluster) {
        return cluster.getNodeByName(this.getNodeName());
    }

    @Override
    public boolean isApplicableTo(NodeContext node) {
        switch (this.getLevel()) {
            case CLUSTER: {
                return true;
            }
            case STRIPE: {
                return this.getStripeId().isPresent() && node.getCluster().getStripeId(node.getStripeUID()).isPresent() && this.getStripeId().getAsInt() == node.getCluster().getStripeId(node.getStripeUID()).getAsInt();
            }
            case NODE: {
                return node.getNode().getName().equals(this.getNodeName());
            }
        }
        throw new AssertionError(this.getLevel());
    }
}

