/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.nomad;

import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.entity.Entity;
import org.terracotta.diagnostic.client.DiagnosticService;
import org.terracotta.diagnostic.client.connection.DiagnosticServices;
import org.terracotta.diagnostic.client.connection.MultiDiagnosticServiceProvider;
import org.terracotta.diagnostic.model.LogicalServerState;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.UID;
import org.terracotta.dynamic_config.api.model.nomad.ClusterActivationNomadChange;
import org.terracotta.dynamic_config.api.model.nomad.DynamicConfigNomadChange;
import org.terracotta.dynamic_config.cli.api.nomad.NomadManager;
import org.terracotta.inet.HostPort;
import org.terracotta.nomad.NomadEnvironment;
import org.terracotta.nomad.client.NomadClient;
import org.terracotta.nomad.client.NomadEndpoint;
import org.terracotta.nomad.client.change.ChangeResultReceiver;
import org.terracotta.nomad.client.change.NomadChange;
import org.terracotta.nomad.client.recovery.RecoveryResultReceiver;
import org.terracotta.nomad.client.results.DiscoverResultsReceiver;
import org.terracotta.nomad.client.results.LoggingResultReceiver;
import org.terracotta.nomad.client.results.MultiChangeResultReceiver;
import org.terracotta.nomad.client.results.MultiRecoveryResultReceiver;
import org.terracotta.nomad.client.status.MultiDiscoveryResultReceiver;
import org.terracotta.nomad.entity.client.NomadEntity;
import org.terracotta.nomad.entity.client.NomadEntityProvider;
import org.terracotta.nomad.messages.AcceptRejectResponse;
import org.terracotta.nomad.messages.CommitMessage;
import org.terracotta.nomad.server.ChangeRequestState;
import org.terracotta.nomad.server.NomadException;
import org.terracotta.nomad.server.NomadServer;

public class DefaultNomadManager<T>
implements NomadManager<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NomadManager.class);
    public static final EnumSet<LogicalServerState> ALLOWED = EnumSet.of(LogicalServerState.ACTIVE, LogicalServerState.PASSIVE, LogicalServerState.ACTIVE_RECONNECTING, LogicalServerState.DIAGNOSTIC);
    private final NomadEnvironment environment;
    private final MultiDiagnosticServiceProvider multiDiagnosticServiceProvider;
    private final NomadEntityProvider nomadEntityProvider;

    public DefaultNomadManager(NomadEnvironment environment, MultiDiagnosticServiceProvider multiDiagnosticServiceProvider, NomadEntityProvider nomadEntityProvider) {
        this.environment = environment;
        this.multiDiagnosticServiceProvider = multiDiagnosticServiceProvider;
        this.nomadEntityProvider = nomadEntityProvider;
    }

    @Override
    public void runConfigurationDiscovery(Map<Node.Endpoint, LogicalServerState> nodes, DiscoverResultsReceiver<T> results) {
        LOGGER.debug("Attempting to discover nodes: {}", nodes);
        List<Node.Endpoint> orderedList = DefaultNomadManager.keepOnlineAndOrderPassivesFirst(nodes);
        try (NomadClient<T> client = this.createDiagnosticNomadClient(orderedList);){
            client.tryDiscovery((DiscoverResultsReceiver)new MultiDiscoveryResultReceiver(Arrays.asList(new LoggingResultReceiver(), results)));
        }
    }

    @Override
    public void runClusterActivation(Collection<Node.Endpoint> nodes, Cluster cluster, ChangeResultReceiver<T> results) {
        LOGGER.debug("Attempting to activate cluster: {}", (Object)cluster.toShapeString());
        try (NomadClient<T> client = this.createDiagnosticNomadClient(new ArrayList<Node.Endpoint>(nodes));){
            client.tryApplyChange((ChangeResultReceiver)new MultiChangeResultReceiver(Arrays.asList(new LoggingResultReceiver(), results)), (NomadChange)new ClusterActivationNomadChange(cluster));
        }
    }

    @Override
    public void runConfigurationChange(Cluster destinationCluster, Map<Node.Endpoint, LogicalServerState> onlineNodes, DynamicConfigNomadChange changes, ChangeResultReceiver<T> results) {
        LOGGER.debug("Attempting to make co-ordinated configuration change: {} on nodes: {}", (Object)changes, onlineNodes);
        DefaultNomadManager.checkServerStates(onlineNodes);
        try (NomadClient<T> client = this.createBiChannelNomadClient(destinationCluster, onlineNodes);){
            client.tryApplyChange((ChangeResultReceiver)new MultiChangeResultReceiver(Arrays.asList(new LoggingResultReceiver(), results)), (NomadChange)changes);
        }
    }

    @Override
    public void runConfigurationRepair(Map<Node.Endpoint, LogicalServerState> onlineActivatedNodes, int totalNodeCount, RecoveryResultReceiver<T> results, ChangeRequestState forcedState) {
        LOGGER.debug("Attempting to repair configuration on nodes: {}", onlineActivatedNodes.keySet());
        List<Node.Endpoint> orderedList = DefaultNomadManager.keepOnlineAndOrderPassivesFirst(onlineActivatedNodes);
        try (NomadClient<T> client = this.createDiagnosticNomadClient(orderedList);){
            client.tryRecovery((RecoveryResultReceiver)new MultiRecoveryResultReceiver(Arrays.asList(new LoggingResultReceiver(), results)), totalNodeCount, forcedState);
        }
    }

    private NomadClient<T> createDiagnosticNomadClient(List<Node.Endpoint> expectedOnlineNodes) {
        LOGGER.trace("createDiagnosticNomadClient({})", expectedOnlineNodes);
        List<NomadEndpoint<T>> nomadEndpoints = this.createDiagnosticNomadEndpoints(expectedOnlineNodes);
        String host = this.environment.getHost();
        String user = this.environment.getUser();
        Clock clock = this.environment.getClock();
        return new NomadClient(nomadEndpoints, host, user, clock);
    }

    private NomadClient<T> createBiChannelNomadClient(Cluster destinationCluster, Map<Node.Endpoint, LogicalServerState> onlineNodes) {
        List<Object> nomadEndpoints;
        LOGGER.trace("createBiChannelNomadClient({}, {})", (Object)destinationCluster, onlineNodes);
        DefaultNomadManager.checkServerStates(onlineNodes);
        final Map<UID, List> onlineNodesPerStripe = destinationCluster.getStripes().stream().collect(Collectors.toMap(Stripe::getUID, stripe -> {
            ArrayList<Node.Endpoint> stripeNodes = new ArrayList<Node.Endpoint>();
            for (Node node : stripe.getNodes()) {
                for (Node.Endpoint endpoint : onlineNodes.keySet()) {
                    if (!endpoint.getNodeUID().equals((Object)node.getUID())) continue;
                    stripeNodes.add(node.determineEndpoint(endpoint));
                }
            }
            return stripeNodes;
        }));
        for (Map.Entry<UID, List> entry : onlineNodesPerStripe.entrySet()) {
            if (!entry.getValue().isEmpty()) continue;
            throw new IllegalStateException("Entire stripe UID: " + entry.getKey() + " is not online in cluster: " + destinationCluster.toShapeString());
        }
        HashMap<UID, NomadEntity> nomadEntities = new HashMap<UID, NomadEntity>(onlineNodesPerStripe.size());
        final Runnable cleanup = () -> nomadEntities.values().forEach(Entity::close);
        for (Map.Entry<UID, List> entry : onlineNodesPerStripe.entrySet()) {
            List addresses = entry.getValue();
            try {
                LOGGER.trace("Connecting to stripe UID: {} using nodes: {}", (Object)entry.getKey(), (Object)addresses);
                nomadEntities.put(entry.getKey(), this.nomadEntityProvider.fetchNomadEntity((Collection)addresses.stream().map(e -> e.getHostPort().createInetSocketAddress()).collect(Collectors.toList())));
            }
            catch (ConnectionException e2) {
                cleanup.run();
                throw new IllegalStateException("Unable to connect to stripe UID: " + entry.getKey() + " using endpoints: " + entry.getValue() + ". Server states: " + onlineNodes + ". Error:: " + e2.getMessage(), e2);
            }
        }
        final Map<UID, NomadEndpoint> stripeEndpoints = onlineNodesPerStripe.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            HostPort firstAddress = ((Node.Endpoint)((List)e.getValue()).get(0)).getHostPort();
            return new NomadEndpoint(firstAddress, (NomadServer)nomadEntities.get(e.getKey()));
        }));
        try {
            List<Node.Endpoint> orderedList = DefaultNomadManager.keepOnlineAndOrderPassivesFirst(onlineNodes);
            Collections.reverse(orderedList);
            LOGGER.trace("Connecting to diagnostic ports: {}", orderedList);
            nomadEndpoints = this.createDiagnosticNomadEndpoints(orderedList);
        }
        catch (RuntimeException e3) {
            cleanup.run();
            throw e3;
        }
        final ConcurrentHashMap cache = new ConcurrentHashMap(stripeEndpoints.size());
        nomadEndpoints = nomadEndpoints.stream().map(e -> new NomadEndpoint<T>(e.getHostPort(), (NomadServer)e){

            public AcceptRejectResponse commit(CommitMessage message) throws NomadException {
                HostPort address = this.getHostPort();
                UID stripeUID = onlineNodesPerStripe.entrySet().stream().filter(e -> ((List)e.getValue()).stream().anyMatch(endpoint -> endpoint.getHostPort().equals((Object)address))).findAny().map(Map.Entry::getKey).get();
                CompletableFuture result = cache.computeIfAbsent(stripeUID, uid -> {
                    LOGGER.trace("Committing topology change to stripe UID: {}", (Object)stripeUID);
                    LOGGER.trace("Sending commit message: {} to stripe UID: {}", (Object)message, (Object)stripeUID);
                    CompletableFuture<AcceptRejectResponse> c = new CompletableFuture<AcceptRejectResponse>();
                    try {
                        AcceptRejectResponse acceptRejectResponse = ((NomadEndpoint)stripeEndpoints.get(stripeUID)).commit(message);
                        LOGGER.trace("Received commit response: {} from stripe UID: {}", (Object)message, (Object)stripeUID);
                        c.complete(acceptRejectResponse);
                    }
                    catch (RuntimeException | NomadException e) {
                        LOGGER.trace("Received commit failure: '{}' from stripe UID: {}", new Object[]{e.getMessage(), stripeUID, e});
                        c.completeExceptionally(e);
                    }
                    return c;
                });
                try {
                    return (AcceptRejectResponse)result.get();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new NomadException((Throwable)ie);
                }
                catch (ExecutionException e2) {
                    Throwable cause = e2.getCause();
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    if (cause instanceof NomadException) {
                        throw (NomadException)cause;
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new NomadException(e2.getMessage(), (Throwable)e2);
                }
            }
        }).collect(Collectors.toList());
        String host = this.environment.getHost();
        String user = this.environment.getUser();
        Clock clock = this.environment.getClock();
        return new NomadClient<T>(nomadEndpoints, host, user, clock){

            public void close() {
                try {
                    super.close();
                }
                finally {
                    cleanup.run();
                }
            }
        };
    }

    private List<NomadEndpoint<T>> createDiagnosticNomadEndpoints(List<Node.Endpoint> expectedOnlineNodes) {
        LOGGER.trace("createDiagnosticNomadEndpoints({})", expectedOnlineNodes);
        DiagnosticServices diagnosticServices = this.multiDiagnosticServiceProvider.fetchOnlineDiagnosticServices(expectedOnlineNodes.stream().collect(Collectors.toMap(Node.Endpoint::getNodeUID, a -> a.getHostPort().createInetSocketAddress())));
        return expectedOnlineNodes.stream().map(endpoint -> {
            final DiagnosticService diagnosticService = (DiagnosticService)diagnosticServices.getDiagnosticService((Object)endpoint.getNodeUID()).get();
            NomadServer nomadServer = (NomadServer)diagnosticService.getProxy(NomadServer.class);
            return new NomadEndpoint<T>(endpoint.getHostPort(), nomadServer){

                public void close() {
                    diagnosticService.close();
                }
            };
        }).collect(Collectors.toList());
    }

    private static List<Node.Endpoint> keepOnlineAndOrderPassivesFirst(Map<Node.Endpoint, LogicalServerState> expectedOnlineNodes) {
        Predicate<Map.Entry> online = e -> !((LogicalServerState)e.getValue()).isUnknown() && !((LogicalServerState)e.getValue()).isUnreacheable();
        Predicate<Map.Entry> actives = e -> ((LogicalServerState)e.getValue()).isActive();
        return Stream.concat(expectedOnlineNodes.entrySet().stream().filter(online.and(actives.negate())), expectedOnlineNodes.entrySet().stream().filter(online.and(actives))).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private static void checkServerStates(Map<Node.Endpoint, LogicalServerState> expectedOnlineNodes) {
        for (Map.Entry<Node.Endpoint, LogicalServerState> entry : expectedOnlineNodes.entrySet()) {
            if (ALLOWED.contains(entry.getValue())) continue;
            throw new IllegalStateException("Nomad system is currently not accessible. Node: " + entry.getKey() + " is in state: " + entry.getValue());
        }
    }
}

