/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.command;

import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.dynamic_config.api.model.Configuration;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Operation;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.cli.api.command.ConfigurationMutationAction;

public class UnsetAction
extends ConfigurationMutationAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnsetAction.class);

    public UnsetAction() {
        super(Operation.UNSET);
    }

    @Override
    protected void validate() {
        super.validate();
        List configs = this.configurations.stream().filter(configuration -> configuration.getSetting() == Setting.LICENSE_FILE).collect(Collectors.toList());
        this.configurations.removeIf(cfg -> cfg.getSetting() == Setting.LICENSE_FILE);
        if (!configs.isEmpty()) {
            Configuration configuration2 = (Configuration)configs.get(configs.size() - 1);
            configuration2.getValue().map(x$0 -> Paths.get(x$0, new String[0])).ifPresent(path -> {
                throw new IllegalArgumentException("Setting license-file must not be assigned to a value in unset command");
            });
            Collection<Node.Endpoint> peers = this.findRuntimePeers(this.node);
            LOGGER.debug("Uninstalling license from nodes: {}", (Object)UnsetAction.toString(peers));
            this.upgradeLicense(peers, null);
            this.output.info("License removal successful.", new Object[0]);
        }
    }
}

