/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.command;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.common.struct.Tuple2;
import org.terracotta.diagnostic.client.connection.DiagnosticServices;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.ClusterState;
import org.terracotta.dynamic_config.api.model.FailoverPriority;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.service.ClusterFactory;
import org.terracotta.dynamic_config.api.service.ClusterValidator;
import org.terracotta.dynamic_config.cli.api.command.RemoteAction;
import org.terracotta.inet.HostPort;

public class ImportAction
extends RemoteAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportAction.class);
    private List<HostPort> nodes = Collections.emptyList();
    private Path configFile;

    public void setNodes(List<HostPort> nodes) {
        this.nodes = nodes;
    }

    public void setConfigFile(Path configFile) {
        this.configFile = configFile;
    }

    @Override
    public final void run() {
        Cluster cluster = this.loadCluster();
        FailoverPriority failoverPriority = (FailoverPriority)cluster.getFailoverPriority().orElse(null);
        if (failoverPriority != null && failoverPriority.getType() == FailoverPriority.Type.CONSISTENCY) {
            int voterCount = failoverPriority.getVoters();
            for (Stripe stripe : cluster.getStripes()) {
                int nodeCount = stripe.getNodes().size();
                int sum = voterCount + nodeCount;
                if (sum % 2 != 0) continue;
                LOGGER.warn(System.lineSeparator() + "=========================================================================================================" + System.lineSeparator() + "IMPORTANT: The sum (" + sum + ") of voter count (" + voterCount + ") and number of nodes (" + nodeCount + ") in stripe " + stripe.getName() + System.lineSeparator() + "is an even number. An even-numbered configuration is more likely to experience split-brain situations." + System.lineSeparator() + "=========================================================================================================" + System.lineSeparator());
            }
        }
        new ClusterValidator(cluster).validate(ClusterState.CONFIGURING);
        if (this.nodes.isEmpty()) {
            this.nodes = cluster.determineEndpoints().stream().map(Node.Endpoint::getHostPort).collect(Collectors.toList());
        }
        for (HostPort node : this.nodes) {
            if (!this.isActivated(node)) continue;
            throw new IllegalStateException("Node: " + node + " is already activated");
        }
        this.output.info("Importing cluster configuration from config file: {} to nodes: {}", new Object[]{this.configFile, ImportAction.toString(this.nodes)});
        DiagnosticServices diagnosticServices = this.multiDiagnosticServiceProvider.fetchOnlineDiagnosticServices(ImportAction.hostPortsToMap(this.nodes));
        Object object = null;
        try {
            ImportAction.dynamicConfigServices(diagnosticServices).map(Tuple2::getT2).forEach(service -> service.setUpcomingCluster(cluster));
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (diagnosticServices != null) {
                if (object != null) {
                    try {
                        diagnosticServices.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    diagnosticServices.close();
                }
            }
        }
        this.output.info("Command successful!", new Object[0]);
    }

    private Cluster loadCluster() {
        ClusterFactory clusterCreator = new ClusterFactory();
        Cluster cluster = clusterCreator.create(this.configFile);
        LOGGER.debug("Config property file parsed and cluster topology validation successful");
        return cluster;
    }
}

