/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.command;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.ConfigFormat;
import org.terracotta.dynamic_config.api.service.ConfigPropertiesTranslator;
import org.terracotta.dynamic_config.api.service.Props;
import org.terracotta.dynamic_config.cli.api.command.RemoteAction;
import org.terracotta.dynamic_config.cli.api.output.FileOutputService;
import org.terracotta.inet.HostPort;

public class ExportAction
extends RemoteAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportAction.class);
    private HostPort node;
    private Path outputFile;
    private boolean includeDefaultValues;
    private boolean wantsRuntimeConfig;
    private ConfigFormat outputFormat = ConfigFormat.CONFIG;

    public void setNode(HostPort node) {
        this.node = node;
    }

    public void setOutputFile(Path outputFile) {
        this.outputFile = outputFile;
    }

    public void setIncludeDefaultValues(boolean includeDefaultValues) {
        this.includeDefaultValues = includeDefaultValues;
    }

    public void setWantsRuntimeConfig(boolean wantsRuntimeConfig) {
        this.wantsRuntimeConfig = wantsRuntimeConfig;
    }

    public void setOutputFormat(ConfigFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        if (this.outputFile != null && this.outputFile.toFile().exists() && !Files.isRegularFile(this.outputFile, new LinkOption[0])) {
            throw new IllegalArgumentException(this.outputFile + " is not a file");
        }
        Cluster cluster = this.wantsRuntimeConfig ? this.getRuntimeCluster(this.node) : this.getUpcomingCluster(this.node);
        String out = this.buildOutput(cluster, this.outputFile);
        if (this.outputFile != null) {
            if (this.outputFile.toFile().exists()) {
                LOGGER.warn(this.outputFile + " already exists. Replacing this file.");
            } else {
                Path dir = this.outputFile.toAbsolutePath().getParent();
                if (dir != null && !dir.toFile().exists()) {
                    try {
                        Files.createDirectories(dir, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
            try {
                this.output = new FileOutputService(this.outputFile);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        try {
            this.output.out(out, new Object[0]);
            this.output.info("Command successful!", new Object[0]);
        }
        finally {
            this.output.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String buildOutput(Cluster cluster, Path outputFile) {
        ConfigFormat outputFormat = outputFile == null ? this.outputFormat : ConfigFormat.from((Path)outputFile);
        switch (outputFormat) {
            case JSON: {
                return this.toJson(cluster);
            }
            case CONFIG: 
            case PROPERTIES: {
                Properties properties;
                Properties userDefined = cluster.toProperties(false, false, false);
                Properties hidden = cluster.toProperties(false, false, true);
                hidden.keySet().removeAll(userDefined.keySet());
                Properties defaults = cluster.toProperties(false, true, false);
                defaults.keySet().removeAll(userDefined.keySet());
                String fileHeader = "Timestamp of configuration export: " + Instant.now().toString();
                String userDefinedHeader = "User-defined configurations";
                String defaultHeader = "Default configurations";
                String hiddenHeader = "Hidden internal system configurations (only for informational, import and repair purposes): please do not alter, get, set, unset them.";
                if (outputFormat == ConfigFormat.PROPERTIES) {
                    try (StringWriter out = new StringWriter();){
                        out.write("# " + fileHeader + "\n");
                        Props.store((Writer)out, (Properties)userDefined, (String)userDefinedHeader);
                        if (!defaults.isEmpty() && this.includeDefaultValues) {
                            out.write("\n");
                            Props.store((Writer)out, (Properties)defaults, (String)defaultHeader);
                        }
                        if (!hidden.isEmpty()) {
                            out.write("\n");
                            Props.store((Writer)out, (Properties)hidden, (String)hiddenHeader);
                        }
                        String string = out.toString().replace("\n", System.lineSeparator());
                        return string;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                ConfigPropertiesTranslator translator = new ConfigPropertiesTranslator();
                Properties properties2 = this.includeDefaultValues ? defaults : null;
                if (!hidden.isEmpty()) {
                    properties = hidden;
                    return translator.writeConfigOutput(fileHeader, userDefined, userDefinedHeader, properties2, defaultHeader, properties, hiddenHeader);
                }
                properties = null;
                return translator.writeConfigOutput(fileHeader, userDefined, userDefinedHeader, properties2, defaultHeader, properties, hiddenHeader);
            }
        }
        throw new IllegalArgumentException("Invalid format: " + outputFormat + ". Supported formats: " + String.join((CharSequence)", ", ConfigFormat.supported()));
    }
}

