/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.command;

import java.time.Clock;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.terracotta.diagnostic.model.LogicalServerState;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.LockContext;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.service.ConfigurationConsistencyAnalyzer;
import org.terracotta.dynamic_config.api.service.ConfigurationConsistencyState;
import org.terracotta.dynamic_config.cli.api.command.RemoteAction;
import org.terracotta.dynamic_config.cli.api.nomad.DefaultNomadManager;
import org.terracotta.inet.HostPort;
import org.terracotta.nomad.messages.ChangeDetails;
import org.terracotta.nomad.server.NomadServerMode;

public class DiagnosticAction
extends RemoteAction {
    private static final DateTimeFormatter ISO_8601 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final Clock CLOCK = Clock.systemDefaultZone();
    private static final ZoneId ZONE_ID = CLOCK.getZone();
    private List<HostPort> nodes = Collections.emptyList();
    private String outputFormat = "text";

    public void setNodes(List<HostPort> nodes) {
        this.nodes = nodes;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    @Override
    public final void run() {
        if (Stream.of("text", "json").noneMatch(Predicate.isEqual(this.outputFormat))) {
            throw new IllegalArgumentException("Output format must be set to 'text' or 'json'");
        }
        Map<Node.Endpoint, LogicalServerState> allNodes = this.findRuntimePeersStatus(this.nodes);
        ConfigurationConsistencyAnalyzer configurationConsistencyAnalyzer = this.analyzeNomadConsistency(allNodes);
        Collection<HostPort> onlineNodes = DiagnosticAction.sort(configurationConsistencyAnalyzer.getOnlineNodes().keySet());
        Collection<HostPort> onlineActivatedNodes = DiagnosticAction.sort(configurationConsistencyAnalyzer.getOnlineNodesActivated().keySet());
        Collection<HostPort> onlineInConfigurationNodes = DiagnosticAction.sort(configurationConsistencyAnalyzer.getOnlineNodesInConfiguration().keySet());
        Collection<HostPort> onlineInRepairNodes = DiagnosticAction.sort(configurationConsistencyAnalyzer.getOnlineNodesInRepair().keySet());
        Collection<HostPort> nodesPendingRestart = DiagnosticAction.sort(allNodes.keySet().stream().map(Node.Endpoint::getHostPort).filter(onlineNodes::contains).filter(this::mustBeRestarted).collect(Collectors.toSet()));
        if ("text".equals(this.outputFormat)) {
            this.output.out(this.toText(configurationConsistencyAnalyzer, allNodes, onlineNodes, onlineActivatedNodes, onlineInConfigurationNodes, onlineInRepairNodes, nodesPendingRestart), new Object[0]);
        } else if ("json".equals(this.outputFormat)) {
            this.output.out(this.toJson(configurationConsistencyAnalyzer, allNodes, onlineNodes, onlineActivatedNodes, onlineInConfigurationNodes, onlineInRepairNodes, nodesPendingRestart), new Object[0]);
        } else {
            throw new AssertionError((Object)this.outputFormat);
        }
    }

    private String toText(ConfigurationConsistencyAnalyzer configurationConsistencyAnalyzer, Map<Node.Endpoint, LogicalServerState> allNodes, Collection<HostPort> onlineNodes, Collection<HostPort> onlineActivatedNodes, Collection<HostPort> onlineInConfigurationNodes, Collection<HostPort> onlineInRepairNodes, Collection<HostPort> nodesPendingRestart) {
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator());
        sb.append("Diagnostic result:").append(System.lineSeparator()).append(System.lineSeparator());
        sb.append("[Cluster]").append(System.lineSeparator());
        sb.append(" - Nodes: ").append(allNodes.size()).append(DiagnosticAction.details(allNodes.keySet())).append(System.lineSeparator());
        sb.append(" - Nodes online: ").append(onlineNodes.size()).append(DiagnosticAction.details(onlineNodes)).append(System.lineSeparator());
        sb.append(" - Nodes online, configured and activated: ").append(onlineActivatedNodes.size()).append(DiagnosticAction.details(onlineActivatedNodes)).append(System.lineSeparator());
        sb.append(" - Nodes online, configured and in repair: ").append(onlineInRepairNodes.size()).append(DiagnosticAction.details(onlineInRepairNodes)).append(System.lineSeparator());
        sb.append(" - Nodes online, new and being configured: ").append(onlineInConfigurationNodes.size()).append(DiagnosticAction.details(onlineInConfigurationNodes)).append(System.lineSeparator());
        sb.append(" - Nodes pending restart: ").append(nodesPendingRestart.size()).append(DiagnosticAction.details(nodesPendingRestart)).append(System.lineSeparator());
        sb.append(" - Configuration state: ").append(configurationConsistencyAnalyzer.getDescription()).append(System.lineSeparator());
        allNodes.keySet().forEach(endpoint -> {
            sb.append("[").append(endpoint).append("]").append(System.lineSeparator());
            sb.append(" - Node state: ").append(configurationConsistencyAnalyzer.getState(endpoint.getHostPort())).append(System.lineSeparator());
            sb.append(" - Node online, configured and activated: ").append(onlineActivatedNodes.contains(endpoint.getHostPort()) ? "YES" : "NO").append(System.lineSeparator());
            sb.append(" - Node online, configured and in repair: ").append(onlineInRepairNodes.contains(endpoint.getHostPort()) ? "YES" : "NO").append(System.lineSeparator());
            sb.append(" - Node online, new and being configured: ").append(onlineInConfigurationNodes.contains(endpoint.getHostPort()) ? "YES" : "NO").append(System.lineSeparator());
            if (onlineNodes.contains(endpoint.getHostPort())) {
                sb.append(" - Node restart required: ").append(nodesPendingRestart.contains(endpoint.getHostPort()) ? "YES" : "NO").append(System.lineSeparator());
                sb.append(" - Node configuration change in progress: ").append(this.hasIncompleteChange((Node.Endpoint)endpoint) ? "YES" : "NO").append(System.lineSeparator());
                configurationConsistencyAnalyzer.getDiscoveryResponse(endpoint.getHostPort()).ifPresent(discoverResponse -> {
                    sb.append(" - Node can accept new changes: ").append(discoverResponse.getMode() == NomadServerMode.ACCEPTING ? "YES" : "NO").append(System.lineSeparator());
                    sb.append(" - Node current configuration version: ").append(discoverResponse.getCurrentVersion()).append(System.lineSeparator());
                    sb.append(" - Node highest configuration version: ").append(discoverResponse.getHighestVersion()).append(System.lineSeparator());
                    ChangeDetails latestChange = discoverResponse.getLatestChange();
                    if (latestChange != null) {
                        sb.append(" - Node last configuration change UUID: ").append(latestChange.getChangeUuid()).append(System.lineSeparator());
                        sb.append(" - Node last configuration state: ").append(latestChange.getState()).append(System.lineSeparator());
                        sb.append(" - Node last configuration created at: ").append(latestChange.getCreationTimestamp().atZone(ZONE_ID).toLocalDateTime().format(ISO_8601)).append(System.lineSeparator());
                        sb.append(" - Node last configuration created from: ").append(latestChange.getCreationHost()).append(System.lineSeparator());
                        sb.append(" - Node last configuration created by: ").append(latestChange.getCreationUser()).append(System.lineSeparator());
                        sb.append(" - Node last configuration change details: ").append(latestChange.getOperation().getSummary()).append(System.lineSeparator());
                        sb.append(" - Node last mutation at: ").append(discoverResponse.getLastMutationTimestamp().atZone(ZONE_ID).toLocalDateTime().format(ISO_8601)).append(System.lineSeparator());
                        sb.append(" - Node last mutation from: ").append(discoverResponse.getLastMutationHost()).append(System.lineSeparator());
                        sb.append(" - Node last mutation by: ").append(discoverResponse.getLastMutationUser()).append(System.lineSeparator());
                    }
                });
            }
        });
        return sb.toString();
    }

    private String toJson(ConfigurationConsistencyAnalyzer analyzer, Map<Node.Endpoint, LogicalServerState> allNodes, Collection<HostPort> onlineNodes, Collection<HostPort> onlineActivatedNodes, Collection<HostPort> onlineInConfigurationNodes, Collection<HostPort> onlineInRepairNodes, Collection<HostPort> nodesPendingRestart) {
        Cluster cluster = analyzer.findCluster().orElseGet(() -> this.getUpcomingCluster(onlineNodes));
        Optional lockContext = analyzer.findLockContext();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("nodes", allNodes.size());
        map.put("stripes", cluster.getStripeCount());
        map.put("nodesOnline", onlineNodes.size());
        map.put("nodesUnreachable", Math.max(0, allNodes.size() - onlineNodes.size()));
        map.put("nodesRequiringRestart", nodesPendingRestart.size());
        map.put("nodesInActiveMode", onlineActivatedNodes.size());
        map.put("nodesInRepairMode", onlineInRepairNodes.size());
        map.put("nodesInConfigMode", onlineInConfigurationNodes.size());
        map.put("configLocked", lockContext.isPresent());
        map.put("configLockedToken", lockContext.map(LockContext::getToken).orElse(null));
        map.put("configDiscoveryFailed", analyzer.getState() == ConfigurationConsistencyState.DISCOVERY_FAILURE);
        map.put("configDiscoveryFailure", analyzer.getDiscoverFailure().map(Throwable::getMessage).orElse(null));
        map.put("configInconsistent", analyzer.getState() == ConfigurationConsistencyState.INCONSISTENT);
        map.put("configPartitioned", analyzer.getState() == ConfigurationConsistencyState.PARTITIONED);
        map.put("configChangeInProgress", analyzer.getState() == ConfigurationConsistencyState.CHANGE_IN_PROGRESS);
        map.put("configChangeCommittedAll", analyzer.getState() == ConfigurationConsistencyState.ALL_ACCEPTING);
        map.put("configChangeCommittedOnline", analyzer.getState() == ConfigurationConsistencyState.ONLINE_ACCEPTING);
        map.put("configChangePreparedAll", analyzer.getState() == ConfigurationConsistencyState.ALL_PREPARED);
        map.put("configChangePreparedOnline", analyzer.getState() == ConfigurationConsistencyState.ONLINE_PREPARED);
        map.put("configChangePartiallyPrepared", analyzer.getState() == ConfigurationConsistencyState.PARTIALLY_PREPARED);
        map.put("configChangePartiallyCommitted", analyzer.getState() == ConfigurationConsistencyState.PARTIALLY_COMMITTED);
        map.put("configChangePartiallyRolledBack", analyzer.getState() == ConfigurationConsistencyState.PARTIALLY_ROLLED_BACK);
        Map<LogicalServerState, Long> states = allNodes.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.counting()));
        map.put("nodeStates", states);
        map.put("readyForTopologyChange", !lockContext.isPresent() && EnumSet.of(ConfigurationConsistencyState.ALL_ACCEPTING, ConfigurationConsistencyState.ONLINE_ACCEPTING).contains(analyzer.getState()) && nodesPendingRestart.isEmpty() && onlineActivatedNodes.size() == onlineNodes.size() && states.getOrDefault(LogicalServerState.ACTIVE, 0L) + states.getOrDefault(LogicalServerState.ACTIVE_RECONNECTING, 0L) == (long)cluster.getStripeCount() && DefaultNomadManager.ALLOWED.containsAll(states.keySet()));
        map.put("manualInterventionRequired", !nodesPendingRestart.isEmpty() || EnumSet.of(ConfigurationConsistencyState.INCONSISTENT, new ConfigurationConsistencyState[]{ConfigurationConsistencyState.PARTITIONED, ConfigurationConsistencyState.ALL_PREPARED, ConfigurationConsistencyState.ONLINE_PREPARED, ConfigurationConsistencyState.PARTIALLY_PREPARED, ConfigurationConsistencyState.PARTIALLY_COMMITTED, ConfigurationConsistencyState.PARTIALLY_ROLLED_BACK}).contains(analyzer.getState()) || !onlineActivatedNodes.isEmpty() && states.getOrDefault(LogicalServerState.ACTIVE, 0L) + states.getOrDefault(LogicalServerState.ACTIVE_RECONNECTING, 0L) != (long)cluster.getStripeCount() || !Collections.disjoint(EnumSet.of(LogicalServerState.ACTIVE_SUSPENDED, LogicalServerState.PASSIVE_SUSPENDED, LogicalServerState.START_SUSPENDED), states.keySet()));
        return this.toJson(map);
    }

    private static String details(Collection<?> items) {
        return items.isEmpty() ? "" : " (" + DiagnosticAction.toString(items) + ")";
    }

    private static Collection<HostPort> sort(Collection<HostPort> addrs) {
        TreeSet<HostPort> sorted = new TreeSet<HostPort>(Comparator.comparing(HostPort::toString));
        sorted.addAll(addrs);
        return sorted;
    }
}

