/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.command;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.common.struct.Measure;
import org.terracotta.common.struct.TimeUnit;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.FailoverPriority;
import org.terracotta.dynamic_config.api.model.Identifier;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.PropertyHolder;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.UID;
import org.terracotta.dynamic_config.api.model.nomad.NodeRemovalNomadChange;
import org.terracotta.dynamic_config.api.model.nomad.StripeRemovalNomadChange;
import org.terracotta.dynamic_config.api.model.nomad.TopologyNomadChange;
import org.terracotta.dynamic_config.cli.api.command.TopologyAction;
import org.terracotta.dynamic_config.cli.api.converter.OperationType;

public class DetachAction
extends TopologyAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DetachAction.class);
    protected Measure<TimeUnit> stopWaitTime = Measure.of((long)120L, (Enum)TimeUnit.SECONDS);
    protected Measure<TimeUnit> stopDelay = Measure.of((long)2L, (Enum)TimeUnit.SECONDS);
    protected Identifier sourceIdentifier;
    protected final Collection<Node.Endpoint> onlineNodesToRemove = new ArrayList<Node.Endpoint>(1);
    protected PropertyHolder source;
    protected Stripe stripeToDetach;

    public void setStopWaitTime(Measure<TimeUnit> stopWaitTime) {
        this.stopWaitTime = stopWaitTime;
    }

    public void setStopDelay(Measure<TimeUnit> stopDelay) {
        this.stopDelay = stopDelay;
    }

    public void setSourceIdentifier(Identifier sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.destinationCluster.getNodeCount() == 1) {
            throw new IllegalStateException("Unable to detach since destination cluster contains only 1 node");
        }
        if (this.operationType == OperationType.NODE) {
            int nodeCount;
            int voterCount;
            int sum;
            this.source = (PropertyHolder)this.sourceIdentifier.findObject(this.destinationCluster, Scope.NODE).orElseThrow(() -> new IllegalStateException("Source: " + this.sourceIdentifier + " is not part of cluster: " + this.destinationCluster.toShapeString()));
            if (this.destination.getNodeUID().equals((Object)this.source.getUID())) {
                throw new IllegalArgumentException("The destination and the source nodes must not be the same");
            }
            if (!this.destinationCluster.inSameStripe(new UID[]{this.source.getUID(), this.destination.getNodeUID()}).isPresent()) {
                throw new IllegalStateException("Source node: " + this.sourceIdentifier + " is not present in the same stripe as destination: " + this.destination);
            }
            Stripe destinationStripe = (Stripe)this.destinationCluster.getStripeByNode(this.destination.getNodeUID()).get();
            if (destinationStripe.getNodeCount() == 1) {
                throw new IllegalStateException("Unable to detach since destination stripe contains only 1 node");
            }
            FailoverPriority failoverPriority = (FailoverPriority)this.destinationCluster.getFailoverPriority().orElse(null);
            if (failoverPriority != null && failoverPriority.getType() == FailoverPriority.Type.CONSISTENCY && (sum = (voterCount = failoverPriority.getVoters()) + (nodeCount = destinationStripe.getNodes().size())) % 2 != 0) {
                LOGGER.warn(System.lineSeparator() + "===================================================================================" + System.lineSeparator() + "IMPORTANT: The sum (" + sum + ") of voter count (" + voterCount + ") and number of nodes (" + nodeCount + ") in this stripe " + System.lineSeparator() + "is an odd number, which will become even with the removal of node " + this.sourceIdentifier + "." + System.lineSeparator() + "An even-numbered configuration is more likely to experience split-brain situations." + System.lineSeparator() + "===================================================================================" + System.lineSeparator());
            }
            for (Node.Endpoint endpoint : this.destinationOnlineNodes.keySet()) {
                if (endpoint.getNodeUID().equals((Object)this.source.getUID())) continue;
                this.validateLogOrFail(() -> !this.mustBeRestarted(endpoint), "Impossible to do any topology change. Node: " + endpoint + " is waiting to be restarted to apply some pending changes. Please refer to the Troubleshooting Guide for more help.");
            }
            this.markNodeForRemoval(this.source.getUID());
        } else {
            this.source = (PropertyHolder)this.sourceIdentifier.findObject(this.destinationCluster, Scope.STRIPE).orElseThrow(() -> new IllegalStateException("Source: " + this.sourceIdentifier + " is not part of cluster: " + this.destinationCluster.toShapeString()));
            this.stripeToDetach = (Stripe)this.destinationCluster.getStripe(this.source.getUID()).get();
            if (this.stripeToDetach.containsNode(this.destination.getNodeUID())) {
                throw new IllegalStateException("Source: " + this.sourceIdentifier + " and destination: " + this.destination + " are part of the same stripe: " + this.stripeToDetach.toShapeString());
            }
            if (this.destinationClusterActivated && this.destinationCluster.getStripeId(this.source.getUID()).getAsInt() == 1) {
                throw new IllegalStateException("Removing the leading stripe is not allowed");
            }
            for (Node.Endpoint endpoint : this.destinationOnlineNodes.keySet()) {
                if (this.stripeToDetach.containsNode(endpoint.getNodeUID())) continue;
                this.validateLogOrFail(() -> !this.mustBeRestarted(endpoint), "Impossible to do any topology change. Node: " + endpoint + " is waiting to be restarted to apply some pending changes. Please refer to the Troubleshooting Guide for more help.");
            }
            this.stripeToDetach.getNodes().stream().map(Node::getUID).forEach(this::markNodeForRemoval);
        }
        if (this.operationType == OperationType.NODE && !this.onlineNodesToRemove.isEmpty() && this.areAllNodesActivated(this.onlineNodesToRemove)) {
            this.validateLogOrFail(this.onlineNodesToRemove::isEmpty, "Nodes to be detached: " + DetachAction.toString(this.onlineNodesToRemove) + " are online. Nodes must be safely shutdown first. Please refer to the Troubleshooting Guide for more help.");
        }
    }

    @Override
    protected Cluster updateTopology() {
        Cluster cluster = this.destinationCluster.clone();
        switch (this.operationType) {
            case NODE: {
                this.output.info("Detaching node: {} from cluster: {}", new Object[]{this.source.getName(), this.destinationCluster.getName()});
                cluster.removeNode(this.source.getUID());
                break;
            }
            case STRIPE: {
                this.output.info("Detaching stripe: {} from cluster: {}", new Object[]{this.source.getName(), this.destinationCluster.getName()});
                cluster.removeStripe(this.source.getUID());
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.operationType.name());
            }
        }
        return cluster;
    }

    @Override
    protected TopologyNomadChange buildNomadChange(Cluster result) {
        switch (this.operationType) {
            case NODE: {
                return new NodeRemovalNomadChange(result, ((Stripe)this.destinationCluster.getStripeByNode(this.source.getUID()).get()).getUID(), (Node)this.destinationCluster.getNode(this.source.getUID()).get());
            }
            case STRIPE: {
                return new StripeRemovalNomadChange(result, this.stripeToDetach);
            }
        }
        throw new UnsupportedOperationException(this.operationType.name());
    }

    @Override
    protected void onNomadChangeReady(TopologyNomadChange nomadChange) {
        if (this.operationType == OperationType.NODE) {
            this.resetAndStopNodesToRemove();
            this.destinationOnlineNodes.keySet().removeAll(this.onlineNodesToRemove);
            this.destinationOnlineNodes = this.getLogicalServerStates(this.destinationOnlineNodes.keySet());
        }
    }

    @Override
    protected void onNomadChangeSuccess(TopologyNomadChange nomadChange) {
        if (this.operationType == OperationType.STRIPE) {
            this.resetAndStopNodesToRemove();
        }
    }

    @Override
    protected Collection<Node.Endpoint> getAllOnlineSourceNodes() {
        return this.onlineNodesToRemove;
    }

    private void resetAndStopNodesToRemove() {
        if (!this.onlineNodesToRemove.isEmpty()) {
            this.output.info("Reset nodes: {}", new Object[]{DetachAction.toString(this.onlineNodesToRemove)});
            for (Node.Endpoint endpoint : this.onlineNodesToRemove) {
                try {
                    this.reset(endpoint);
                }
                catch (RuntimeException e2) {
                    LOGGER.warn("Error during reset of node: {}: {}", new Object[]{endpoint, e2.getMessage(), e2});
                }
            }
            this.output.info("Stopping nodes: {}", new Object[]{DetachAction.toString(this.onlineNodesToRemove)});
            this.stopNodes(this.onlineNodesToRemove, Duration.ofMillis(this.stopWaitTime.getQuantity((Enum)TimeUnit.MILLISECONDS)), Duration.ofMillis(this.stopDelay.getQuantity((Enum)TimeUnit.MILLISECONDS)));
            this.destinationOnlineNodes.keySet().removeAll(this.onlineNodesToRemove);
            this.destinationOnlineNodes.entrySet().forEach(e -> e.setValue(this.getLogicalServerState((Node.Endpoint)e.getKey())));
        }
    }

    private void markNodeForRemoval(UID nodeUID) {
        this.destinationOnlineNodes.keySet().stream().filter(endpoint -> endpoint.getNodeUID().equals((Object)nodeUID)).findAny().ifPresent(this.onlineNodesToRemove::add);
    }
}

