/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.command;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Configuration;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.UID;
import org.terracotta.dynamic_config.api.service.ClusterValidator;

public class ConfigurationInput {
    private static final Map<Pattern, BiConsumer<ConfigurationInput, Matcher>> CFG_STRIPE_PATTERNS = new LinkedHashMap<Pattern, BiConsumer<ConfigurationInput, Matcher>>();
    private static final Map<Pattern, BiConsumer<ConfigurationInput, Matcher>> CFG_NODE_PATTERNS = new LinkedHashMap<Pattern, BiConsumer<ConfigurationInput, Matcher>>();
    private static final Map<Pattern, BiConsumer<ConfigurationInput, Matcher>> CFG_STRIPE_OR_NODE_PATTERNS = new LinkedHashMap<Pattern, BiConsumer<ConfigurationInput, Matcher>>();
    private static final String CFG_STRIPE_SEP = "stripe:";
    private static final String CFG_NODE_SEP = "node:";
    private static final String CFG_GRP_NAME = "([^:/\\\\<>\"|*? ,=%{}]+):";
    private static final String SEP = "\\.";
    private static final String GRP_SETTING = "([a-z\\-]+)";
    private static final String GRP_KEY = "([^=:]+)";
    private static final String ASSIGN = "=";
    private static final String GRP_VALUE = "([^=]+)";
    private final String cliInput;
    private String stripeOrNodeName = null;
    private Setting setting = null;
    private Scope level = null;
    private String key = null;
    private String value = null;

    public ConfigurationInput(String cliInput) {
        Objects.requireNonNull(cliInput);
        this.cliInput = cliInput.trim();
        if (this.parseAsNamedProperty().booleanValue()) {
            this.validate();
        }
    }

    private void update(Setting setting, Scope level, String name, String key, String value) {
        this.setting = Objects.requireNonNull(setting);
        this.stripeOrNodeName = Objects.requireNonNull(name);
        this.level = level;
        this.key = key;
        this.value = value == null ? null : value.trim();
    }

    private Boolean parseAsNamedProperty() {
        Matcher matcher;
        String setting;
        String scope = "";
        String[] s = this.cliInput.split(ASSIGN)[0].split(":");
        if (s.length == 3) {
            scope = s[0];
            if (!scope.equals("stripe") && !scope.equals("node")) {
                throw new IllegalArgumentException("Scope '" + scope + ":' specified in property '" + this.cliInput + "' is invalid. Scope must be one of 'stripe:' or 'node:'");
            }
            setting = s[2];
        } else if (s.length == 2) {
            setting = s[1];
        } else {
            return false;
        }
        int idx = setting.indexOf(".");
        Setting.fromName((String)setting.substring(0, idx == -1 ? setting.length() : idx));
        if (scope.equals("node")) {
            for (Map.Entry<Pattern, BiConsumer<ConfigurationInput, Matcher>> entry : CFG_NODE_PATTERNS.entrySet()) {
                matcher = entry.getKey().matcher(this.cliInput);
                if (!matcher.matches()) continue;
                entry.getValue().accept(this, matcher);
                return true;
            }
        }
        if (scope.equals("stripe")) {
            for (Map.Entry<Pattern, BiConsumer<ConfigurationInput, Matcher>> entry : CFG_STRIPE_PATTERNS.entrySet()) {
                matcher = entry.getKey().matcher(this.cliInput);
                if (!matcher.matches()) continue;
                entry.getValue().accept(this, matcher);
                return true;
            }
        }
        for (Map.Entry<Pattern, BiConsumer<ConfigurationInput, Matcher>> entry : CFG_STRIPE_OR_NODE_PATTERNS.entrySet()) {
            matcher = entry.getKey().matcher(this.cliInput);
            if (!matcher.matches()) continue;
            entry.getValue().accept(this, matcher);
            return true;
        }
        throw new IllegalArgumentException("Invalid input: '" + this.cliInput + "'");
    }

    private void validate() {
        String scope = this.level == Scope.STRIPE ? "stripe" : (this.level == Scope.NODE ? "node" : "stripe or node");
        ClusterValidator.validateName((String)this.stripeOrNodeName, (String)scope);
        if (!this.setting.isMap() && this.key != null) {
            throw new IllegalArgumentException("Invalid input: '" + this.cliInput + "'. Reason: Setting '" + this.setting + "' is not a map and must not have a key");
        }
        if (this.level != null) {
            if (!this.setting.allows(this.level)) {
                throw new IllegalArgumentException("Invalid input: '" + this.cliInput + "'. Reason: Setting '" + this.setting + "' does not allow any operation at " + this.level + " level");
            }
            try {
                this.setting.validate(this.key, this.value, this.level);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Invalid input: '" + this.cliInput + "'. Reason: " + e.getMessage(), e);
            }
        }
    }

    public Configuration toConfiguration(Cluster cluster) {
        Configuration config = this.valueOf(cluster);
        if (config == null) {
            config = Configuration.valueOf((String)this.cliInput);
        }
        return config;
    }

    public boolean isNamedProperty() {
        return this.stripeOrNodeName != null && !this.stripeOrNodeName.isEmpty();
    }

    private Configuration valueOf(Cluster cluster) {
        int stripeId;
        if (!this.isNamedProperty()) {
            return null;
        }
        Optional node = cluster.getNodeByName(this.stripeOrNodeName);
        Optional stripe = cluster.getStripeByName(this.stripeOrNodeName);
        if (this.level == null) {
            if (node.isPresent() && stripe.isPresent()) {
                throw new IllegalArgumentException(String.format("Name '%s' in setting '%s' is both a stripe name and node name. It must be qualified with either 'stripe:' or 'node:'", this.stripeOrNodeName, this.cliInput));
            }
        } else {
            if (this.level.equals((Object)Scope.STRIPE) && !stripe.isPresent()) {
                throw new IllegalArgumentException(String.format("Name '%s' in setting '%s' is not a recognized stripe.", this.stripeOrNodeName, this.cliInput));
            }
            if (this.level.equals((Object)Scope.NODE) && !node.isPresent()) {
                throw new IllegalArgumentException(String.format("Name '%s' in setting '%s' is not a recognized node.", this.stripeOrNodeName, this.cliInput));
            }
        }
        if (!stripe.isPresent() && !node.isPresent()) {
            throw new IllegalArgumentException(String.format("Name '%s' in setting '%s' is not a recognized stripe or node.", this.stripeOrNodeName, this.cliInput));
        }
        if (this.level == null) {
            this.level = stripe.isPresent() ? Scope.STRIPE : Scope.NODE;
        }
        Integer nodeId = null;
        if (this.level.equals((Object)Scope.STRIPE)) {
            stripeId = cluster.getStripeId(((Stripe)stripe.get()).getUID()).getAsInt();
        } else {
            UID nodeUid = ((Node)node.get()).getUID();
            stripeId = cluster.getStripeIdByNode(nodeUid).getAsInt();
            nodeId = cluster.getNodeId(nodeUid).getAsInt();
        }
        return new Configuration(this.cliInput, this.setting, this.level, Integer.valueOf(stripeId), nodeId, this.key, this.value);
    }

    public static Setting getSetting(String cliInput) {
        ConfigurationInput c = new ConfigurationInput(cliInput);
        if (c.isNamedProperty()) {
            return c.setting;
        }
        return Configuration.valueOf((String)c.cliInput).getSetting();
    }

    public static String getKey(String cliInput) {
        ConfigurationInput c = new ConfigurationInput(cliInput);
        if (c.isNamedProperty()) {
            return c.key;
        }
        return Configuration.valueOf((String)c.cliInput).getKey();
    }

    static {
        CFG_STRIPE_PATTERNS.put(Pattern.compile("^stripe:([^:/\\\\<>\"|*? ,=%{}]+):([a-z\\-]+)\\.([^=:]+)$"), (input, matcher) -> input.update(Setting.fromName((String)matcher.group(2)), Scope.STRIPE, matcher.group(1), matcher.group(3), null));
        CFG_STRIPE_PATTERNS.put(Pattern.compile("^stripe:([^:/\\\\<>\"|*? ,=%{}]+):([a-z\\-]+)$"), (input, matcher) -> input.update(Setting.fromName((String)matcher.group(2)), Scope.STRIPE, matcher.group(1), null, null));
        CFG_STRIPE_PATTERNS.put(Pattern.compile("^stripe:([^:/\\\\<>\"|*? ,=%{}]+):([a-z\\-]+)\\.([^=:]+)=$"), (input, matcher) -> input.update(Setting.fromName((String)matcher.group(2)), Scope.STRIPE, matcher.group(1), matcher.group(3), ""));
        CFG_STRIPE_PATTERNS.put(Pattern.compile("^stripe:([^:/\\\\<>\"|*? ,=%{}]+):([a-z\\-]+)=$"), (input, matcher) -> input.update(Setting.fromName((String)matcher.group(2)), Scope.STRIPE, matcher.group(1), null, ""));
        CFG_STRIPE_PATTERNS.put(Pattern.compile("^stripe:([^:/\\\\<>\"|*? ,=%{}]+):([a-z\\-]+)\\.([^=:]+)=([^=]+)$"), (input, matcher) -> input.update(Setting.fromName((String)matcher.group(2)), Scope.STRIPE, matcher.group(1), matcher.group(3), matcher.group(4)));
        CFG_STRIPE_PATTERNS.put(Pattern.compile("^stripe:([^:/\\\\<>\"|*? ,=%{}]+):([a-z\\-]+)=([^=]+)$"), (input, matcher) -> input.update(Setting.fromName((String)matcher.group(2)), Scope.STRIPE, matcher.group(1), null, matcher.group(3)));
        CFG_NODE_PATTERNS.put(Pattern.compile("^node:([^:/\\\\<>\"|*? ,=%{}]+):([a-z\\-]+)\\.([^=:]+)=([^=]+)$"), (input, matcher) -> input.update(Setting.fromName((String)matcher.group(2)), Scope.NODE, matcher.group(1), matcher.group(3), matcher.group(4)));
        CFG_NODE_PATTERNS.put(Pattern.compile("^node:([^:/\\\\<>\"|*? ,=%{}]+):([a-z\\-]+)=([^=]+)$"), (input, matcher) -> input.update(Setting.fromName((String)matcher.group(2)), Scope.NODE, matcher.group(1), null, matcher.group(3)));
        CFG_NODE_PATTERNS.put(Pattern.compile("^node:([^:/\\\\<>\"|*? ,=%{}]+):([a-z\\-]+)\\.([^=:]+)=$"), (input, matcher) -> input.update(Setting.fromName((String)matcher.group(2)), Scope.NODE, matcher.group(1), matcher.group(3), ""));
        CFG_NODE_PATTERNS.put(Pattern.compile("^node:([^:/\\\\<>\"|*? ,=%{}]+):([a-z\\-]+)=$"), (input, matcher) -> input.update(Setting.fromName((String)matcher.group(2)), Scope.NODE, matcher.group(1), null, ""));
        CFG_NODE_PATTERNS.put(Pattern.compile("^node:([^:/\\\\<>\"|*? ,=%{}]+):([a-z\\-]+)\\.([^=:]+)$"), (input, matcher) -> input.update(Setting.fromName((String)matcher.group(2)), Scope.NODE, matcher.group(1), matcher.group(3), null));
        CFG_NODE_PATTERNS.put(Pattern.compile("^node:([^:/\\\\<>\"|*? ,=%{}]+):([a-z\\-]+)$"), (input, matcher) -> input.update(Setting.fromName((String)matcher.group(2)), Scope.NODE, matcher.group(1), null, null));
        CFG_STRIPE_OR_NODE_PATTERNS.put(Pattern.compile("^([^:/\\\\<>\"|*? ,=%{}]+):([a-z\\-]+)\\.([^=:]+)=([^=]+)$"), (input, matcher) -> input.update(Setting.fromName((String)matcher.group(2)), null, matcher.group(1), matcher.group(3), matcher.group(4)));
        CFG_STRIPE_OR_NODE_PATTERNS.put(Pattern.compile("^([^:/\\\\<>\"|*? ,=%{}]+):([a-z\\-]+)=([^=]+)$"), (input, matcher) -> input.update(Setting.fromName((String)matcher.group(2)), null, matcher.group(1), null, matcher.group(3)));
        CFG_STRIPE_OR_NODE_PATTERNS.put(Pattern.compile("^([^:/\\\\<>\"|*? ,=%{}]+):([a-z\\-]+)\\.([^=:]+)=$"), (input, matcher) -> input.update(Setting.fromName((String)matcher.group(2)), null, matcher.group(1), matcher.group(3), ""));
        CFG_STRIPE_OR_NODE_PATTERNS.put(Pattern.compile("^([^:/\\\\<>\"|*? ,=%{}]+):([a-z\\-]+)=$"), (input, matcher) -> input.update(Setting.fromName((String)matcher.group(2)), null, matcher.group(1), null, ""));
        CFG_STRIPE_OR_NODE_PATTERNS.put(Pattern.compile("^([^:/\\\\<>\"|*? ,=%{}]+):([a-z\\-]+)\\.([^=:]+)$"), (input, matcher) -> input.update(Setting.fromName((String)matcher.group(2)), null, matcher.group(1), matcher.group(3), null));
        CFG_STRIPE_OR_NODE_PATTERNS.put(Pattern.compile("^([^:/\\\\<>\"|*? ,=%{}]+):([a-z\\-]+)$"), (input, matcher) -> input.update(Setting.fromName((String)matcher.group(2)), null, matcher.group(1), null, null));
    }
}

