/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.command;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.common.struct.Measure;
import org.terracotta.common.struct.TimeUnit;
import org.terracotta.common.struct.Tuple2;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.FailoverPriority;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.nomad.NodeAdditionNomadChange;
import org.terracotta.dynamic_config.api.model.nomad.StripeAdditionNomadChange;
import org.terracotta.dynamic_config.api.model.nomad.TopologyNomadChange;
import org.terracotta.dynamic_config.api.service.NameGenerator;
import org.terracotta.dynamic_config.cli.api.command.TopologyAction;
import org.terracotta.dynamic_config.cli.api.converter.OperationType;
import org.terracotta.inet.HostPort;

public class AttachAction
extends TopologyAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachAction.class);
    protected Measure<TimeUnit> restartWaitTime = Measure.of((long)120L, (Enum)TimeUnit.SECONDS);
    protected Measure<TimeUnit> restartDelay = Measure.of((long)2L, (Enum)TimeUnit.SECONDS);
    protected final Map<Node.Endpoint, NodeContext> sources = new LinkedHashMap<Node.Endpoint, NodeContext>();
    protected Stripe addedStripe;
    protected String optionalStripeName;
    protected Node addedNode;

    public void setSourceHostPort(HostPort sourceHostPort) {
        this.sources.clear();
        this.getUpcomingNodeContext(sourceHostPort).accept(this.sources::put);
    }

    public void setStripeFromShape(Collection<HostPort> sourceHostPorts, String optionalStripeName) {
        this.sources.clear();
        sourceHostPorts.forEach(hostPort -> this.getUpcomingNodeContext((HostPort)hostPort).accept(this.sources::put));
        this.optionalStripeName = optionalStripeName != null ? optionalStripeName : (String)this.sources.values().stream().map(nodeContext -> ((Stripe)nodeContext.getCluster().getStripeByNode(nodeContext.getNodeUID()).get()).getName()).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public void setStripeFromSource(HostPort sourceStripeHostPort) {
        Tuple2<Node.Endpoint, NodeContext> context = this.getUpcomingNodeContext(sourceStripeHostPort);
        Stripe stripe = ((NodeContext)context.t2).getStripe();
        this.optionalStripeName = stripe.getName();
        this.sources.clear();
        stripe.getNodes().forEach(node -> this.sources.put(node.determineEndpoint((Node.Endpoint)context.t1), new NodeContext(((NodeContext)context.t2).getCluster(), node.getUID())));
    }

    public void setRestartWaitTime(Measure<TimeUnit> restartWaitTime) {
        this.restartWaitTime = restartWaitTime;
    }

    public void setRestartDelay(Measure<TimeUnit> restartDelay) {
        this.restartDelay = restartDelay;
    }

    @Override
    protected void validate() {
        Cluster sourceCluster;
        Node.Endpoint source;
        super.validate();
        if (this.operationType == OperationType.NODE && this.sources.size() > 1) {
            throw new UnsupportedOperationException("Cannot attach more than 1 node at a time");
        }
        for (Node.Endpoint endpoint : this.sources.keySet()) {
            if (!this.destination.getNodeUID().equals((Object)endpoint.getNodeUID())) continue;
            throw new IllegalArgumentException("The destination and the source endpoints must not be the same");
        }
        for (Node.Endpoint endpoint : this.destinationOnlineNodes.keySet()) {
            this.validateLogOrFail(() -> !this.mustBeRestarted(endpoint), "Impossible to do any topology change. Node: " + endpoint + " is waiting to be restarted to apply some pending changes. Please refer to the Troubleshooting Guide for more help.");
        }
        for (Node.Endpoint endpoint : this.sources.keySet()) {
            Collection collection = this.destinationCluster.determineEndpoints(this.destination);
            if (collection.contains(endpoint)) {
                throw new IllegalArgumentException("Source node: " + endpoint + " is already part of cluster: " + this.destinationCluster.toShapeString());
            }
            if (!this.isActivated(endpoint)) continue;
            throw new IllegalArgumentException("Source node: " + endpoint + " cannot be attached since it is part of an existing cluster with name: " + this.getRuntimeCluster(endpoint).getName());
        }
        Stripe destinationStripe = (Stripe)this.destinationCluster.getStripeByNode(this.destination.getNodeUID()).get();
        if (this.operationType == OperationType.NODE) {
            for (Map.Entry<Node.Endpoint, NodeContext> entry : this.sources.entrySet()) {
                int nodeCount;
                int voterCount;
                int sum;
                source = entry.getKey();
                sourceCluster = entry.getValue().getCluster();
                this.validateLogOrFail(() -> sourceCluster.getNodeCount() == 1, "Source node: " + source + " is part of a stripe containing more than 1 nodes. It must be detached first before being attached to a new stripe. Please refer to the Troubleshooting Guide for more help.");
                FailoverPriority failoverPriority = (FailoverPriority)this.destinationCluster.getFailoverPriority().orElse(null);
                if (failoverPriority == null || failoverPriority.getType() != FailoverPriority.Type.CONSISTENCY || (sum = (voterCount = failoverPriority.getVoters()) + (nodeCount = destinationStripe.getNodes().size())) % 2 == 0) continue;
                LOGGER.warn(System.lineSeparator() + "===================================================================================" + System.lineSeparator() + "IMPORTANT: The sum (" + sum + ") of voter count (" + voterCount + ") and number of nodes (" + nodeCount + ") in this stripe " + System.lineSeparator() + "is an odd number, which will become even with the addition of node " + source + "." + System.lineSeparator() + "An even-numbered configuration is more likely to experience split-brain situations." + System.lineSeparator() + "===================================================================================" + System.lineSeparator());
            }
        }
        if (this.operationType == OperationType.STRIPE) {
            for (Map.Entry<Node.Endpoint, NodeContext> entry : this.sources.entrySet()) {
                source = entry.getKey();
                sourceCluster = entry.getValue().getCluster();
                this.validateLogOrFail(() -> sourceCluster.getStripeCount() == 1, "Source stripe from node: " + source + " is part of a cluster containing more than 1 stripes. It must be detached first before being attached to a new cluster. Please refer to the Troubleshooting Guide for more help.");
            }
            Collection collection = this.sources.keySet().stream().map(Node.Endpoint::getNodeUID).collect(Collectors.toSet());
            for (Map.Entry<Node.Endpoint, NodeContext> entry : this.sources.entrySet()) {
                Collection nodesInStripe = entry.getValue().getStripe().getNodes().stream().map(Node::getUID).collect(Collectors.toSet());
                nodesInStripe.removeAll(collection);
                if (nodesInStripe.isEmpty()) continue;
                throw new IllegalArgumentException("Source node: " + entry.getKey() + " points to a stripe with more than one node and the following nodes were not marked to be attached: " + AttachAction.toString(nodesInStripe));
            }
        }
        switch (this.operationType) {
            case NODE: {
                this.addedNode = this.sources.values().iterator().next().getNode().clone().setUID(this.destinationCluster.newUID());
                if (!this.destinationClusterActivated) break;
                NameGenerator.assignFriendlyNodeName((Cluster)this.destinationCluster, (Stripe)destinationStripe, (Node)this.addedNode);
                break;
            }
            case STRIPE: {
                this.addedStripe = new Stripe().setUID(this.destinationCluster.newUID()).setName(this.optionalStripeName).setNodes(this.sources.values().stream().map(NodeContext::getNode).map(Node::clone).map(node -> node.setUID(this.destinationCluster.newUID())).collect(Collectors.toList()));
                if (!this.destinationClusterActivated) break;
                NameGenerator.assignFriendlyNames((Cluster)this.destinationCluster, (Stripe)this.addedStripe);
            }
        }
    }

    @Override
    protected Cluster updateTopology() {
        Cluster cluster = this.destinationCluster.clone();
        switch (this.operationType) {
            case NODE: {
                this.output.info("Attaching node: {} to stripe: {}", new Object[]{this.addedNode.toShapeString(), ((Stripe)cluster.getStripeByNode(this.destination.getNodeUID()).get()).toShapeString()});
                ((Stripe)cluster.getStripeByNode(this.destination.getNodeUID()).orElseThrow(AssertionError::new)).addNode(this.addedNode);
                break;
            }
            case STRIPE: {
                this.output.info("Attaching a new stripe: {} to cluster: {}", new Object[]{this.addedStripe.toShapeString(), this.destinationCluster.getName()});
                cluster.addStripe(this.addedStripe);
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.operationType.name());
            }
        }
        return cluster;
    }

    @Override
    protected TopologyNomadChange buildNomadChange(Cluster result) {
        switch (this.operationType) {
            case NODE: {
                return new NodeAdditionNomadChange(result, ((Stripe)result.getStripeByNode(this.addedNode.getUID()).get()).getUID(), this.addedNode);
            }
            case STRIPE: {
                return new StripeAdditionNomadChange(result, this.addedStripe);
            }
        }
        throw new UnsupportedOperationException(this.operationType.name());
    }

    @Override
    protected void onNomadChangeReady(TopologyNomadChange nomadChange) {
        this.setUpcomingCluster(this.sources.keySet(), nomadChange.getCluster());
    }

    @Override
    protected void onNomadChangeSuccess(TopologyNomadChange nomadChange) {
        Cluster result = nomadChange.getCluster();
        switch (this.operationType) {
            case NODE: {
                this.activateNodes(this.sources.keySet(), result, null, this.restartDelay, this.restartWaitTime);
                break;
            }
            case STRIPE: {
                this.activateStripe(this.sources.keySet(), result, this.destination, this.restartDelay, this.restartWaitTime);
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.operationType.name());
            }
        }
    }

    @Override
    protected void onNomadChangeFailure(TopologyNomadChange nomadChange, RuntimeException error) {
        LOGGER.error("An error occurred during the attach transaction." + System.lineSeparator() + "The node/stripe information may still be added to the destination cluster: you will need to run the diagnostic / export command to check the state of the transaction." + System.lineSeparator() + "The node/stripe to attach won't be activated and restarted, and their topology will be rolled back to their initial value.");
        this.sources.forEach((endpoint, nodeContext) -> {
            try {
                this.output.info("Rollback topology of node: {}", new Object[]{endpoint});
                this.setUpcomingCluster(Collections.singleton(endpoint), nodeContext.getCluster());
            }
            catch (RuntimeException e) {
                LOGGER.warn("Unable to rollback configuration on node: {}. Error: {}", new Object[]{endpoint, e.getMessage(), e});
            }
        });
        throw error;
    }

    @Override
    protected Collection<Node.Endpoint> getAllOnlineSourceNodes() {
        return this.sources.keySet();
    }
}

