/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.dna.api;

public class PhysicalAction {
    private final String field;
    private final Object value;
    private final int index;
    private final boolean isReference;
    private final int type;
    private static final int TRUE_PHYSICAL = 1;
    private static final int ARRAY_ELEMENT = 2;
    private static final int ENTIRE_ARRAY = 3;
    private static final int SUB_ARRAY = 4;

    public PhysicalAction(Object value) {
        this(null, -1, value, false, 3);
    }

    public PhysicalAction(Object value, int startPos) {
        this(null, startPos, value, false, 4);
    }

    public PhysicalAction(int index, Object value, boolean isReference) {
        this(null, index, value, isReference, 2);
    }

    public PhysicalAction(String field, Object value, boolean isReference) {
        this(field, -1, value, isReference, 1);
    }

    private PhysicalAction(String field, int index, Object value, boolean isReference, int type) {
        this.field = field;
        this.index = index;
        this.value = value;
        this.isReference = isReference;
        this.type = type;
    }

    public String getFieldName() {
        if (this.type != 1) {
            throw new IllegalStateException(String.valueOf(this.type));
        }
        return this.field;
    }

    public Object getObject() {
        return this.value;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public int getArrayIndex() {
        if (this.type != 2 && this.type != 4) {
            throw new IllegalStateException(String.valueOf(this.type));
        }
        return this.index;
    }

    public boolean isTruePhysical() {
        return this.type == 1;
    }

    public boolean isArrayElement() {
        return this.type == 2;
    }

    public boolean isEntireArray() {
        return this.type == 3;
    }

    public boolean isSubArray() {
        return this.type == 4;
    }
}

