/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode.rwsync;

import com.tc.asm.MethodVisitor;
import com.tc.asm.Opcodes;
import com.tc.object.bytecode.ByteCodeUtil;
import com.tc.object.bytecode.rwsync.MethodStrategy;
import java.lang.reflect.Modifier;

public abstract class LockingMethodStrategy
implements MethodStrategy,
Opcodes {
    public static final String THIS$0 = "this$0";
    protected final String lockField;
    protected final String lockTypeName;
    protected final String lockTypeDesc;

    public LockingMethodStrategy(LockType lockType) {
        if (lockType == LockType.READ) {
            this.lockField = "__tc_readLock";
            this.lockTypeName = "java/util/concurrent/locks/ReentrantReadWriteLock$ReadLock";
            this.lockTypeDesc = "Ljava/util/concurrent/locks/ReentrantReadWriteLock$ReadLock;";
        } else {
            this.lockField = "__tc_writeLock";
            this.lockTypeName = "java/util/concurrent/locks/ReentrantReadWriteLock$WriteLock";
            this.lockTypeDesc = "Ljava/util/concurrent/locks/ReentrantReadWriteLock$WriteLock;";
        }
    }

    protected static String getWrappedName(String name) {
        return "__wrapped_" + name;
    }

    protected static int getWrappedAttributes(int attr) {
        return attr & 0xFFFFFFFA | 0x1000 | 2;
    }

    public static void callRenamedMethod(String owner, int access, String name, String desc, MethodVisitor mv) {
        ByteCodeUtil.prepareStackForMethodCall(access, desc, mv);
        int invokeOp = Modifier.isStatic(access) ? 184 : 183;
        mv.visitMethodInsn(invokeOp, owner, LockingMethodStrategy.getWrappedName(name), desc, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LockType {
        READ,
        WRITE;

    }
}

