/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.util.AbstractIdentifier;
import java.io.Serializable;

public class ObjectID
extends AbstractIdentifier
implements Serializable {
    public static final ObjectID NULL_ID = new ObjectID();
    public static final long MAX_ID = 0xFFFFFFFFFFFFFFL;

    public ObjectID(long id) {
        super(id);
    }

    private ObjectID() {
    }

    public ObjectID(long oid, int gid) {
        super(ObjectID.getObjectID(oid, gid));
    }

    private static long getObjectID(long oid, int gid) {
        if (gid < 0 || gid > 254 || oid < 0L || oid > 0xFFFFFFFFFFFFFFL) {
            throw new AssertionError((Object)("Currently only supports upto 255 Groups and 72057594037927935 objects : " + gid + "," + oid));
        }
        long gidLong = (long)gid & 0xFFL;
        oid = (gidLong <<= 56) | oid;
        return oid;
    }

    public String getIdentifierType() {
        return "ObjectID";
    }

    public int getGroupID() {
        if (this.isNull()) {
            return 0;
        }
        long oid = this.toLong();
        long gid = oid & 0xFF00000000000000L;
        if ((gid >>>= 56) < 0L || gid > 254L) {
            throw new AssertionError((Object)("Group ID is not between 0 and 254, the value was = " + gid + " id = " + this.toLong()));
        }
        return (int)gid;
    }

    public long getMaskedObjectID() {
        if (this.isNull()) {
            throw new AssertionError((Object)"Can't call getMaskedObjectID() on NULL ID");
        }
        long oid = this.toLong() & 0xFFFFFFFFFFFFFFL;
        if (oid > 0xFFFFFFFFFFFFFFL || oid < 0L) {
            throw new AssertionError((Object)("Oid is not between 0 and 72057594037927935, the value was = " + oid + " id = " + this.toLong()));
        }
        return oid;
    }

    public String toString() {
        if (this.toLong() == -1L || this.getGroupID() == 0) {
            return super.toString();
        }
        return this.getIdentifierType() + "=" + "[" + this.getGroupID() + ":" + this.getMaskedObjectID() + "]";
    }
}

