/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode;

import com.tc.asm.MethodVisitor;
import com.tc.asm.Opcodes;
import com.tc.asm.Type;
import com.tc.object.ObjectID;
import com.tc.util.Assert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ByteCodeUtil
implements Opcodes {
    private static final String AUTOLOCK_PREFIX = "@";
    private static final String NAMED_LOCK_PREFIX = "^";
    private static final String LITERAL_LOCK_PREFIX = "#";
    public static final String TC_FIELD_PREFIX = "$__tc_";
    public static final String TC_METHOD_PREFIX = "__tc_";
    public static final String METHOD_RENAME_PREFIX = "__tc_wrapped_";
    public static final String SYNC_METHOD_RENAME_PREFIX = "__tc_wrapped_sync_";
    public static final String DMI_METHOD_RENAME_PREFIX = "__tc_dmi_";
    public static final String VALUES_GETTER = "__tc_getallfields";
    public static final String VALUES_GETTER_DESCRIPTION = "(Ljava/util/Map;)V";
    public static final String VALUES_SETTER = "__tc_setfield";
    public static final String VALUES_SETTER_DESCRIPTION = "(Ljava/lang/String;Ljava/lang/Object;)V";
    public static final String MANAGED_VALUES_GETTER = "__tc_getmanagedfield";
    public static final String MANAGED_VALUES_GETTER_DESCRIPTION = "(Ljava/lang/String;)Ljava/lang/Object;";
    public static final String MANAGED_VALUES_SETTER = "__tc_setmanagedfield";
    public static final String MANAGEABLE_CLASS = "com/tc/object/bytecode/Manageable";
    public static final String MANAGEABLE_TYPE = "Lcom/tc/object/bytecode/Manageable;";
    public static final String TRANSPARENT_ACCESS_CLASS = "com/tc/object/bytecode/TransparentAccess";
    public static final String TRANSPARENT_ACCESS_TYPE = "Lcom/tc/object/bytecode/TransparentAccess;";
    public static final String NAMEDCLASSLOADER_CLASS = "com/tc/object/loaders/NamedClassLoader";
    public static final String NAMEDCLASSLOADER_TYPE = "Lcom/tc/object/loaders/NamedClassLoader;";

    public static Method[] purgeTCMethods(Method[] methods) {
        if (methods == null || methods.length == 0) {
            return methods;
        }
        ArrayList<Method> rv = new ArrayList<Method>();
        for (Method method : methods) {
            if (method.getName().startsWith(TC_METHOD_PREFIX)) continue;
            rv.add(method);
        }
        return rv.toArray(new Method[rv.size()]);
    }

    public static String[] addInterface(String[] existing, String toAdd) {
        return ByteCodeUtil.addInterfaces(existing, new String[]{toAdd});
    }

    public static String[] addInterfaces(String[] existing, String[] toAdd) {
        if (existing == null) {
            return toAdd;
        }
        if (toAdd == null) {
            return existing;
        }
        ArrayList<String> newList = new ArrayList<String>(Arrays.asList(existing));
        Set<String> existingAsSet = Collections.unmodifiableSet(new HashSet<String>(newList));
        int n = toAdd.length;
        for (int i = 0; i < n; ++i) {
            if (existingAsSet.contains(toAdd[i])) continue;
            newList.add(toAdd[i]);
        }
        return newList.toArray(new String[newList.size()]);
    }

    public static boolean isPrimitive(Type t) {
        int sort = t.getSort();
        switch (sort) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static String sortToWrapperName(int sort) {
        switch (sort) {
            case 1: {
                return "java/lang/Boolean";
            }
            case 2: {
                return "java/lang/Character";
            }
            case 3: {
                return "java/lang/Byte";
            }
            case 4: {
                return "java/lang/Short";
            }
            case 5: {
                return "java/lang/Integer";
            }
            case 6: {
                return "java/lang/Float";
            }
            case 7: {
                return "java/lang/Long";
            }
            case 8: {
                return "java/lang/Double";
            }
        }
        throw new AssertionError();
    }

    public static String codeToName(String typeCode) {
        if (typeCode == null || typeCode.length() != 1) {
            throw new IllegalArgumentException("invalid type code: " + typeCode);
        }
        char code = typeCode.charAt(0);
        switch (code) {
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'Z': {
                return "boolean";
            }
        }
        throw new IllegalArgumentException("unknown code: " + code);
    }

    public static boolean isAutolockName(String lockName) {
        return lockName == null ? false : lockName.startsWith(AUTOLOCK_PREFIX);
    }

    public static long objectIdFromLockName(String lockName) {
        if (lockName == null || !lockName.startsWith(AUTOLOCK_PREFIX)) {
            throw new IllegalArgumentException("not an autolock name: " + lockName);
        }
        return Long.valueOf(lockName.substring(AUTOLOCK_PREFIX.length()));
    }

    public static boolean isSynthetic(String fieldName) {
        return fieldName.indexOf("$") >= 0;
    }

    public static boolean isTCSynthetic(String fieldName) {
        return fieldName.startsWith(TC_FIELD_PREFIX) || ByteCodeUtil.isParent(fieldName);
    }

    public static boolean isSynthetic(int access) {
        return (0x1000 & access) > 0;
    }

    public static boolean isParent(String fieldName) {
        return fieldName.matches("^this\\$\\d+$");
    }

    public static void pushThis(MethodVisitor c) {
        c.visitVarInsn(25, 0);
    }

    public static void pushInstanceVariable(MethodVisitor c, String className, String fieldName, String description) {
        c.visitFieldInsn(180, className, fieldName, description);
    }

    public static void createParametersToArrayByteCode(MethodVisitor c, Type[] parameters) {
        ByteCodeUtil.createParametersToArrayByteCode(c, parameters, 1);
    }

    public static void createParametersToArrayByteCode(MethodVisitor c, Type[] parameters, int offset) {
        c.visitLdcInsn(new Integer(parameters.length));
        c.visitTypeInsn(189, "java/lang/Object");
        for (int i = 0; i < parameters.length; ++i) {
            c.visitInsn(89);
            c.visitLdcInsn(new Integer(i));
            ByteCodeUtil.addTypeSpecificParameterLoad(c, parameters[i], offset);
            c.visitInsn(83);
            offset += parameters[i].getSize();
        }
    }

    public static void addTypeSpecificParameterLoad(MethodVisitor c, Type type, int offset) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                c.visitVarInsn(type.getOpcode(21), offset);
                break;
            }
            case 1: {
                c.visitTypeInsn(187, "java/lang/Boolean");
                c.visitInsn(89);
                c.visitVarInsn(type.getOpcode(21), offset);
                c.visitMethodInsn(183, "java/lang/Boolean", "<init>", "(Z)V");
                break;
            }
            case 3: {
                c.visitTypeInsn(187, "java/lang/Byte");
                c.visitInsn(89);
                c.visitVarInsn(type.getOpcode(21), offset);
                c.visitMethodInsn(183, "java/lang/Byte", "<init>", "(B)V");
                break;
            }
            case 2: {
                c.visitTypeInsn(187, "java/lang/Character");
                c.visitInsn(89);
                c.visitVarInsn(type.getOpcode(21), offset);
                c.visitMethodInsn(183, "java/lang/Character", "<init>", "(C)V");
                break;
            }
            case 8: {
                c.visitTypeInsn(187, "java/lang/Double");
                c.visitInsn(89);
                c.visitVarInsn(type.getOpcode(21), offset);
                c.visitMethodInsn(183, "java/lang/Double", "<init>", "(D)V");
                break;
            }
            case 6: {
                c.visitTypeInsn(187, "java/lang/Float");
                c.visitInsn(89);
                c.visitVarInsn(type.getOpcode(21), offset);
                c.visitMethodInsn(183, "java/lang/Float", "<init>", "(F)V");
                break;
            }
            case 5: {
                c.visitTypeInsn(187, "java/lang/Integer");
                c.visitInsn(89);
                c.visitVarInsn(type.getOpcode(21), offset);
                c.visitMethodInsn(183, "java/lang/Integer", "<init>", "(I)V");
                break;
            }
            case 7: {
                c.visitTypeInsn(187, "java/lang/Long");
                c.visitInsn(89);
                c.visitVarInsn(type.getOpcode(21), offset);
                c.visitMethodInsn(183, "java/lang/Long", "<init>", "(J)V");
                break;
            }
            case 4: {
                c.visitTypeInsn(187, "java/lang/Short");
                c.visitInsn(89);
                c.visitVarInsn(type.getOpcode(21), offset);
                c.visitMethodInsn(183, "java/lang/Short", "<init>", "(S)V");
                break;
            }
            default: {
                throw new AssertionError((Object)("can't happen:" + type));
            }
        }
    }

    public static void pushMethodArguments(int callingMethodModifier, String desc, MethodVisitor c) {
        int localVariableOffset = ByteCodeUtil.getLocalVariableOffset(callingMethodModifier);
        Type[] args = Type.getArgumentTypes(desc);
        int pos = 0;
        for (Type arg : args) {
            c.visitVarInsn(arg.getOpcode(21), pos + localVariableOffset);
            pos += arg.getSize();
        }
    }

    public static int getFirstLocalVariableOffset(int callingMethodModifier, String desc) {
        Type[] args;
        int localVariableOffset = ByteCodeUtil.getLocalVariableOffset(callingMethodModifier);
        for (Type arg : args = Type.getArgumentTypes(desc)) {
            localVariableOffset += arg.getSize();
        }
        return localVariableOffset;
    }

    public static void prepareStackForMethodCall(int callingMethodModifier, String desc, MethodVisitor c) {
        if (!Modifier.isStatic(callingMethodModifier)) {
            ByteCodeUtil.pushThis(c);
        }
        ByteCodeUtil.pushMethodArguments(callingMethodModifier, desc, c);
    }

    public static int getLocalVariableOffset(int methodModifier) {
        return Modifier.isStatic(methodModifier) ? 0 : 1;
    }

    public static String generateVolatileLockName(ObjectID id, String fieldName) {
        Assert.assertNotNull(id);
        return AUTOLOCK_PREFIX + id.toLong() + fieldName;
    }

    public static String generateAutolockName(ObjectID id) {
        Assert.assertNotNull(id);
        return ByteCodeUtil.generateAutolockName(id.toLong());
    }

    public static String generateNamedLockName(Object obj) {
        Assert.assertNotNull(obj);
        return NAMED_LOCK_PREFIX + obj;
    }

    public static String generateLiteralLockName(String literalValueTypeStr, Object obj) {
        Assert.assertNotNull(obj);
        return literalValueTypeStr + LITERAL_LOCK_PREFIX + obj;
    }

    private static String generateAutolockName(long objectId) {
        return AUTOLOCK_PREFIX + objectId;
    }

    public static String stripGeneratedLockHeader(String lockName) {
        int index = lockName.indexOf(LITERAL_LOCK_PREFIX);
        index = index < 0 ? 1 : index;
        return lockName.substring(index);
    }

    public static String sortToPrimitiveMethodName(int sort) {
        switch (sort) {
            case 1: {
                return "booleanValue";
            }
            case 2: {
                return "charValue";
            }
            case 3: {
                return "byteValue";
            }
            case 4: {
                return "shortValue";
            }
            case 5: {
                return "intValue";
            }
            case 6: {
                return "floatValue";
            }
            case 7: {
                return "longValue";
            }
            case 8: {
                return "doubleValue";
            }
        }
        throw new AssertionError();
    }

    public static String methodDescriptionToReturnType(String desc) {
        Type type = Type.getReturnType(desc);
        return type.getClassName();
    }

    public static String methodDescriptionToMethodArgument(String desc) {
        Type[] types = Type.getArgumentTypes(desc);
        StringBuffer sb = new StringBuffer("(");
        for (int i = 0; i < types.length; ++i) {
            sb.append(types[i].getClassName());
            if (i >= types.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    public static String fieldGetterMethod(String fieldName) {
        return "__tc_get" + fieldName;
    }

    public static String fieldSetterMethod(String fieldName) {
        return "__tc_set" + fieldName;
    }

    public static void systemOutPrintln(MethodVisitor mv, String msg) {
        mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
        mv.visitLdcInsn(msg);
        mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V");
    }

    public static final String classNameToFileName(String className) {
        return className.replace('.', '/') + ".class";
    }

    public static final String classNameToInternalName(String className) {
        return className.replace('.', '/');
    }

    public static final byte[] getBytesForClass(String className, ClassLoader loader) throws ClassNotFoundException {
        String resource = ByteCodeUtil.classNameToFileName(className);
        InputStream is = loader.getResourceAsStream(resource);
        if (is == null) {
            throw new ClassNotFoundException("No resource found for class: " + className);
        }
        try {
            return ByteCodeUtil.getBytesForInputstream(is);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Error reading bytes for " + resource, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] getBytesForInputstream(InputStream is) throws IOException {
        int size = 4096;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        try {
            int read;
            while ((read = is.read(buffer, 0, 4096)) > 0) {
                baos.write(buffer, 0, read);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
        return baos.toByteArray();
    }

    public static void pushDefaultValue(int variable, MethodVisitor c, Type type) {
        if (type.getSort() == 10 || type.getSort() == 9) {
            c.visitInsn(1);
            c.visitVarInsn(58, variable);
        } else {
            c.visitInsn(ByteCodeUtil.getConstant0(type));
            c.visitVarInsn(type.getOpcode(54), variable);
        }
    }

    private static int getConstant0(Type type) {
        if (type.getSort() == 5) {
            return 3;
        }
        if (type.getSort() == 7) {
            return 9;
        }
        if (type.getSort() == 4) {
            return 3;
        }
        if (type.getSort() == 8) {
            return 14;
        }
        if (type.getSort() == 1) {
            return 3;
        }
        if (type.getSort() == 6) {
            return 11;
        }
        if (type.getSort() == 3) {
            return 3;
        }
        if (type.getSort() == 2) {
            return 3;
        }
        throw new AssertionError((Object)("Cannot determine constant 0 of type: " + type.getDescriptor()));
    }
}

