/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.vision.segmenter;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.support.common.SupportPreconditions;
import org.tensorflow.lite.support.image.ColorSpaceType;
import org.tensorflow.lite.support.image.TensorImage;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;
import org.tensorflow.lite.task.vision.segmenter.ColoredLabel;

public enum OutputType {
    CATEGORY_MASK(0){

        @Override
        void assertMasksMatchColoredLabels(List<TensorImage> masks, List<ColoredLabel> coloredLabels) {
            SupportPreconditions.checkArgument((masks.size() == 1 ? 1 : 0) != 0, (Object)("CATRGORY_MASK only allows one TensorImage in the list, providing " + masks.size()));
            TensorImage mask = masks.get(0);
            SupportPreconditions.checkArgument((mask.getColorSpaceType() == ColorSpaceType.GRAYSCALE ? 1 : 0) != 0, (Object)("CATRGORY_MASK only supports masks of ColorSpaceType, GRAYSCALE, providing " + mask.getColorSpaceType()));
        }

        @Override
        List<TensorImage> createMasksFromBuffer(List<ByteBuffer> buffers, int[] maskShape) {
            SupportPreconditions.checkArgument((buffers.size() == 1 ? 1 : 0) != 0, (Object)("CATRGORY_MASK only allows one mask in the buffer list, providing " + buffers.size()));
            ArrayList<TensorImage> masks = new ArrayList<TensorImage>();
            TensorBuffer tensorBuffer = TensorBuffer.createDynamic((DataType)DataType.UINT8);
            tensorBuffer.loadBuffer(buffers.get(0), maskShape);
            TensorImage tensorImage = new TensorImage(DataType.UINT8);
            tensorImage.load(tensorBuffer, ColorSpaceType.GRAYSCALE);
            masks.add(tensorImage);
            return masks;
        }
    }
    ,
    CONFIDENCE_MASK(1){

        @Override
        void assertMasksMatchColoredLabels(List<TensorImage> masks, List<ColoredLabel> coloredLabels) {
            SupportPreconditions.checkArgument((masks.size() == coloredLabels.size() ? 1 : 0) != 0, (Object)String.format("When using CONFIDENCE_MASK, the number of masks (%d) should match the number of coloredLabels (%d).", masks.size(), coloredLabels.size()));
            for (TensorImage mask : masks) {
                SupportPreconditions.checkArgument((mask.getColorSpaceType() == ColorSpaceType.GRAYSCALE ? 1 : 0) != 0, (Object)("CONFIDENCE_MASK only supports masks of ColorSpaceType, GRAYSCALE, providing " + mask.getColorSpaceType()));
            }
        }

        @Override
        List<TensorImage> createMasksFromBuffer(List<ByteBuffer> buffers, int[] maskShape) {
            ArrayList<TensorImage> masks = new ArrayList<TensorImage>();
            for (ByteBuffer buffer : buffers) {
                TensorBuffer tensorBuffer = TensorBuffer.createDynamic((DataType)DataType.FLOAT32);
                tensorBuffer.loadBuffer(buffer, maskShape);
                TensorImage tensorImage = new TensorImage(DataType.FLOAT32);
                tensorImage.load(tensorBuffer, ColorSpaceType.GRAYSCALE);
                masks.add(tensorImage);
            }
            return masks;
        }
    };

    private final int value;

    public int getValue() {
        return this.value;
    }

    abstract void assertMasksMatchColoredLabels(List<TensorImage> var1, List<ColoredLabel> var2);

    abstract List<TensorImage> createMasksFromBuffer(List<ByteBuffer> var1, int[] var2);

    private OutputType(int value) {
        this.value = value;
    }
}

