/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.core;

import android.util.Log;
import java.io.Closeable;

public abstract class BaseTaskApi
implements Closeable {
    private static final String TAG = BaseTaskApi.class.getSimpleName();
    private final long nativeHandle;
    private boolean closed;

    protected BaseTaskApi(long nativeHandle) {
        if (nativeHandle == 0L) {
            throw new IllegalArgumentException("Failed to load C++ pointer from JNI");
        }
        this.nativeHandle = nativeHandle;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.deinit(this.nativeHandle);
        this.closed = true;
    }

    public long getNativeHandle() {
        return this.nativeHandle;
    }

    protected void checkNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Internal error: The task lib has already been closed.");
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                Log.w((String)TAG, (String)"Closing an already closed native lib");
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    protected abstract void deinit(long var1);
}

