/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.schema;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.tensorflow.lite.schema.FakeQuantOptionsT;

public final class FakeQuantOptions
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_23_5_26();
    }

    public static FakeQuantOptions getRootAsFakeQuantOptions(ByteBuffer _bb) {
        return FakeQuantOptions.getRootAsFakeQuantOptions(_bb, new FakeQuantOptions());
    }

    public static FakeQuantOptions getRootAsFakeQuantOptions(ByteBuffer _bb, FakeQuantOptions obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public FakeQuantOptions __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public float min() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getFloat(o + this.bb_pos) : 0.0f;
    }

    public float max() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getFloat(o + this.bb_pos) : 0.0f;
    }

    public int numBits() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public boolean narrowRange() {
        int o = this.__offset(10);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public static int createFakeQuantOptions(FlatBufferBuilder builder, float min, float max, int numBits, boolean narrowRange) {
        builder.startTable(4);
        FakeQuantOptions.addNumBits(builder, numBits);
        FakeQuantOptions.addMax(builder, max);
        FakeQuantOptions.addMin(builder, min);
        FakeQuantOptions.addNarrowRange(builder, narrowRange);
        return FakeQuantOptions.endFakeQuantOptions(builder);
    }

    public static void startFakeQuantOptions(FlatBufferBuilder builder) {
        builder.startTable(4);
    }

    public static void addMin(FlatBufferBuilder builder, float min) {
        builder.addFloat(0, min, 0.0);
    }

    public static void addMax(FlatBufferBuilder builder, float max) {
        builder.addFloat(1, max, 0.0);
    }

    public static void addNumBits(FlatBufferBuilder builder, int numBits) {
        builder.addInt(2, numBits, 0);
    }

    public static void addNarrowRange(FlatBufferBuilder builder, boolean narrowRange) {
        builder.addBoolean(3, narrowRange, false);
    }

    public static int endFakeQuantOptions(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public FakeQuantOptionsT unpack() {
        FakeQuantOptionsT _o = new FakeQuantOptionsT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(FakeQuantOptionsT _o) {
        float _oMin = this.min();
        _o.setMin(_oMin);
        float _oMax = this.max();
        _o.setMax(_oMax);
        int _oNumBits = this.numBits();
        _o.setNumBits(_oNumBits);
        boolean _oNarrowRange = this.narrowRange();
        _o.setNarrowRange(_oNarrowRange);
    }

    public static int pack(FlatBufferBuilder builder, FakeQuantOptionsT _o) {
        if (_o == null) {
            return 0;
        }
        return FakeQuantOptions.createFakeQuantOptions(builder, _o.getMin(), _o.getMax(), _o.getNumBits(), _o.getNarrowRange());
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public FakeQuantOptions get(int j) {
            return this.get(new FakeQuantOptions(), j);
        }

        public FakeQuantOptions get(FakeQuantOptions obj, int j) {
            return obj.__assign(FakeQuantOptions.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

