/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.gpu;

import java.io.Closeable;
import org.tensorflow.lite.gpu.GpuDelegate;

public class CompatibilityList
implements Closeable {
    private static final long INVALID_COMPATIBILITY_LIST_HANDLE = 0L;
    private static final String TFLITE_GPU_LIB = "tensorflowlite_gpu_jni";
    private long compatibilityListHandle = CompatibilityList.createCompatibilityList();

    public boolean isDelegateSupportedOnThisDevice() {
        if (this.compatibilityListHandle == 0L) {
            throw new IllegalStateException("Trying to query a closed compatibilityList.");
        }
        return CompatibilityList.nativeIsDelegateSupportedOnThisDevice(this.compatibilityListHandle);
    }

    public GpuDelegate.Options getBestOptionsForThisDevice() {
        return new GpuDelegate.Options();
    }

    @Override
    public void close() {
        if (this.compatibilityListHandle != 0L) {
            CompatibilityList.deleteCompatibilityList(this.compatibilityListHandle);
            this.compatibilityListHandle = 0L;
        }
    }

    private static native long createCompatibilityList();

    private static native void deleteCompatibilityList(long var0);

    private static native boolean nativeIsDelegateSupportedOnThisDevice(long var0);

    static {
        System.loadLibrary(TFLITE_GPU_LIB);
    }
}

