/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.index;

import java.util.StringJoiner;
import org.tensorflow.ndarray.impl.dimension.Dimension;
import org.tensorflow.ndarray.index.Index;

final class Step
implements Index {
    private final long stride;

    Step(long stride) {
        this.stride = stride;
        if (stride == 0L) {
            throw new IllegalArgumentException("Can not have a stride of 0");
        }
    }

    @Override
    public long numElements(Dimension dim) {
        long length = this.end(dim) - this.start(dim);
        return length / this.stride + (long)(length % this.stride != 0L ? 1 : 0);
    }

    @Override
    public long mapCoordinate(long coordinate, Dimension dim) {
        return this.start(dim) + this.stride * coordinate;
    }

    @Override
    public boolean beginMask() {
        return true;
    }

    @Override
    public boolean endMask() {
        return true;
    }

    @Override
    public long stride() {
        return this.stride;
    }

    public String toString() {
        return new StringJoiner(", ", Step.class.getSimpleName() + "(", ")").add("stride=" + this.stride).toString();
    }

    private long start(Dimension dim) {
        if (this.stride > 0L) {
            return 0L;
        }
        return dim.numElements() - 1L;
    }

    private long end(Dimension dim) {
        if (this.stride > 0L) {
            return dim.numElements();
        }
        return -1L;
    }
}

