/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.buffer;

import org.tensorflow.ndarray.buffer.BooleanDataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBufferWindow;
import org.tensorflow.ndarray.buffer.DoubleDataBuffer;
import org.tensorflow.ndarray.buffer.FloatDataBuffer;
import org.tensorflow.ndarray.buffer.IntDataBuffer;
import org.tensorflow.ndarray.buffer.LongDataBuffer;
import org.tensorflow.ndarray.buffer.ShortDataBuffer;

public interface ByteDataBuffer
extends DataBuffer<Byte> {
    public byte getByte(long var1);

    public ByteDataBuffer setByte(byte var1, long var2);

    default public ByteDataBuffer read(byte[] dst) {
        return this.read(dst, 0, dst.length);
    }

    public ByteDataBuffer read(byte[] var1, int var2, int var3);

    default public ByteDataBuffer write(byte[] src) {
        return this.write(src, 0, src.length);
    }

    public ByteDataBuffer write(byte[] var1, int var2, int var3);

    public IntDataBuffer asInts();

    public ShortDataBuffer asShorts();

    public LongDataBuffer asLongs();

    public FloatDataBuffer asFloats();

    public DoubleDataBuffer asDoubles();

    public BooleanDataBuffer asBooleans();

    @Override
    default public Byte getObject(long index) {
        return this.getByte(index);
    }

    default public ByteDataBuffer setObject(Byte value, long index) {
        return this.setByte(value, index);
    }

    public ByteDataBuffer copyTo(DataBuffer<Byte> var1, long var2);

    default public ByteDataBuffer offset(long index) {
        return this.slice(index, this.size() - index);
    }

    default public ByteDataBuffer narrow(long size) {
        return this.slice(0L, size);
    }

    public ByteDataBuffer slice(long var1, long var3);

    @Override
    default public DataBufferWindow<ByteDataBuffer> window(long size) {
        throw new UnsupportedOperationException();
    }
}

