/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class UnbatchGrad<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> batchedGrad;

    public static <T> UnbatchGrad<T> create(Scope scope, Operand<T> originalInput, Operand<Long> batchIndex, Operand<T> grad, Operand<Long> id, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("UnbatchGrad", scope.makeOpName("UnbatchGrad"));
        opBuilder.addInput(originalInput.asOutput());
        opBuilder.addInput(batchIndex.asOutput());
        opBuilder.addInput(grad.asOutput());
        opBuilder.addInput(id.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new UnbatchGrad<T>(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<T> batchedGrad() {
        return this.batchedGrad;
    }

    @Override
    public Output<T> asOutput() {
        return this.batchedGrad;
    }

    private UnbatchGrad(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.batchedGrad = operation.output(outputIdx++);
    }

    public static class Options {
        private String container;
        private String sharedName;

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        private Options() {
        }
    }
}

