/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class DecodePng<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> image;

    public static <T extends Number> DecodePng<T> create(Scope scope, Operand<String> contents, Class<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("DecodePng", scope.makeOpName("DecodePng"));
        opBuilder.addInput(contents.asOutput());
        opBuilder.setAttr("dtype", DataType.fromClass(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.channels == null) continue;
                opBuilder.setAttr("channels", opts.channels);
            }
        }
        return new DecodePng<T>(opBuilder.build());
    }

    public static Options channels(Long channels) {
        return new Options().channels(channels);
    }

    public Output<T> image() {
        return this.image;
    }

    @Override
    public Output<T> asOutput() {
        return this.image;
    }

    private DecodePng(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.image = operation.output(outputIdx++);
    }

    public static class Options {
        private Long channels;

        public Options channels(Long channels) {
            this.channels = channels;
            return this;
        }

        private Options() {
        }
    }
}

