/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class CropAndResize
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> crops;

    public static <T extends Number> CropAndResize create(Scope scope, Operand<T> image, Operand<Float> boxes, Operand<Integer> boxInd, Operand<Integer> cropSize, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("CropAndResize", scope.makeOpName("CropAndResize"));
        opBuilder.addInput(image.asOutput());
        opBuilder.addInput(boxes.asOutput());
        opBuilder.addInput(boxInd.asOutput());
        opBuilder.addInput(cropSize.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.method != null) {
                    opBuilder.setAttr("method", opts.method);
                }
                if (opts.extrapolationValue == null) continue;
                opBuilder.setAttr("extrapolation_value", opts.extrapolationValue.floatValue());
            }
        }
        return new CropAndResize(opBuilder.build());
    }

    public static Options method(String method) {
        return new Options().method(method);
    }

    public static Options extrapolationValue(Float extrapolationValue) {
        return new Options().extrapolationValue(extrapolationValue);
    }

    public Output<Float> crops() {
        return this.crops;
    }

    @Override
    public Output<Float> asOutput() {
        return this.crops;
    }

    private CropAndResize(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.crops = operation.output(outputIdx++);
    }

    public static class Options {
        private String method;
        private Float extrapolationValue;

        public Options method(String method) {
            this.method = method;
            return this;
        }

        public Options extrapolationValue(Float extrapolationValue) {
            this.extrapolationValue = extrapolationValue;
            return this;
        }

        private Options() {
        }
    }
}

