/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.ArrayList;
import java.util.List;
import org.tensorflow.Graph;
import org.tensorflow.Operation;
import org.tensorflow.Output;
import org.tensorflow.Tensor;

public final class Session
implements AutoCloseable {
    private final Graph graph;
    private final Graph.Reference graphRef;
    private final Object nativeHandleLock = new Object();
    private long nativeHandle;
    private int numActiveRuns;

    public Session(Graph g) {
        this(g, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session(Graph g, byte[] config) {
        this.graph = g;
        try (Graph.Reference r = g.ref();){
            this.nativeHandle = config == null ? Session.allocate(r.nativeHandle()) : Session.allocate2(r.nativeHandle(), null, config);
            this.graphRef = g.ref();
        }
    }

    Session(Graph g, long nativeHandle) {
        this.graph = g;
        this.nativeHandle = nativeHandle;
        this.graphRef = g.ref();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.graphRef.close();
        Object object = this.nativeHandleLock;
        synchronized (object) {
            if (this.nativeHandle == 0L) {
                return;
            }
            while (this.numActiveRuns > 0) {
                try {
                    this.nativeHandleLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            Session.delete(this.nativeHandle);
            this.nativeHandle = 0L;
        }
    }

    public Runner runner() {
        return new Runner();
    }

    private static native long allocate(long var0);

    private static native long allocate2(long var0, String var2, byte[] var3);

    private static native void delete(long var0);

    private static native byte[] run(long var0, byte[] var2, long[] var3, long[] var4, int[] var5, long[] var6, int[] var7, long[] var8, boolean var9, long[] var10);

    public static final class Run {
        public List<Tensor<?>> outputs;
        public byte[] metadata;
    }

    public final class Runner {
        private ArrayList<Output<?>> inputs = new ArrayList();
        private ArrayList<Tensor<?>> inputTensors = new ArrayList();
        private ArrayList<Output<?>> outputs = new ArrayList();
        private ArrayList<Operation> targets = new ArrayList();
        private byte[] runOptions = null;

        public Runner feed(String operation, Tensor<?> t) {
            return this.feed(this.parseOutput(operation), t);
        }

        public Runner feed(String operation, int index, Tensor<?> t) {
            Operation op = this.operationByName(operation);
            if (op != null) {
                this.inputs.add(op.output(index));
                this.inputTensors.add(t);
            }
            return this;
        }

        public Runner feed(Output<?> o, Tensor<?> t) {
            this.inputs.add(o);
            this.inputTensors.add(t);
            return this;
        }

        public Runner fetch(String operation) {
            return this.fetch(this.parseOutput(operation));
        }

        public Runner fetch(String operation, int index) {
            Operation op = this.operationByName(operation);
            if (op != null) {
                this.outputs.add(op.output(index));
            }
            return this;
        }

        public Runner fetch(Output<?> output) {
            this.outputs.add(output);
            return this;
        }

        public Runner addTarget(String operation) {
            Operation op = this.operationByName(operation);
            if (op != null) {
                this.targets.add(op);
            }
            return this;
        }

        public Runner addTarget(Operation operation) {
            this.targets.add(operation);
            return this;
        }

        public Runner setOptions(byte[] options) {
            this.runOptions = options;
            return this;
        }

        public List<Tensor<?>> run() {
            return this.runHelper((boolean)false).outputs;
        }

        public Run runAndFetchMetadata() {
            return this.runHelper(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Run runHelper(boolean wantMetadata) {
            byte[] byArray;
            long[] inputTensorHandles = new long[this.inputTensors.size()];
            long[] inputOpHandles = new long[this.inputs.size()];
            int[] inputOpIndices = new int[this.inputs.size()];
            long[] outputOpHandles = new long[this.outputs.size()];
            int[] outputOpIndices = new int[this.outputs.size()];
            long[] targetOpHandles = new long[this.targets.size()];
            long[] outputTensorHandles = new long[this.outputs.size()];
            int idx = 0;
            for (Tensor<?> tensor : this.inputTensors) {
                inputTensorHandles[idx++] = tensor.getNativeHandle();
            }
            idx = 0;
            for (Output output : this.inputs) {
                inputOpHandles[idx] = output.op().getUnsafeNativeHandle();
                inputOpIndices[idx] = output.index();
                ++idx;
            }
            idx = 0;
            for (Output output : this.outputs) {
                outputOpHandles[idx] = output.op().getUnsafeNativeHandle();
                outputOpIndices[idx] = output.index();
                ++idx;
            }
            idx = 0;
            for (Operation operation : this.targets) {
                targetOpHandles[idx++] = operation.getUnsafeNativeHandle();
            }
            Object var11_18 = null;
            try (Reference runRef = new Reference();){
                byArray = Session.run(Session.this.nativeHandle, this.runOptions, inputTensorHandles, inputOpHandles, inputOpIndices, outputOpHandles, outputOpIndices, targetOpHandles, wantMetadata, outputTensorHandles);
            }
            ArrayList outputs = new ArrayList();
            for (long h : outputTensorHandles) {
                try {
                    outputs.add(Tensor.fromHandle(h));
                }
                catch (Exception e) {
                    for (Tensor tensor : outputs) {
                        tensor.close();
                    }
                    outputs.clear();
                    throw e;
                }
            }
            Run ret = new Run();
            ret.outputs = outputs;
            ret.metadata = byArray;
            return ret;
        }

        private Operation operationByName(String opName) {
            Operation op = Session.this.graph.operation(opName);
            if (op == null) {
                throw new IllegalArgumentException("No Operation named [" + opName + "] in the Graph");
            }
            return op;
        }

        private Output<?> parseOutput(String opName) {
            int colon = opName.lastIndexOf(58);
            if (colon == -1 || colon == opName.length() - 1) {
                return new Output(this.operationByName(opName), 0);
            }
            try {
                String op = opName.substring(0, colon);
                int index = Integer.parseInt(opName.substring(colon + 1));
                return new Output(this.operationByName(op), index);
            }
            catch (NumberFormatException e) {
                return new Output(this.operationByName(opName), 0);
            }
        }

        private class Reference
        implements AutoCloseable {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Reference() {
                Object object = Session.this.nativeHandleLock;
                synchronized (object) {
                    if (Session.this.nativeHandle == 0L) {
                        throw new IllegalStateException("run() cannot be called on the Session after close()");
                    }
                    ++Session.this.numActiveRuns;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                Object object = Session.this.nativeHandleLock;
                synchronized (object) {
                    if (Session.this.nativeHandle == 0L) {
                        return;
                    }
                    if (--Session.this.numActiveRuns == 0) {
                        Session.this.nativeHandleLock.notifyAll();
                    }
                }
            }
        }
    }
}

