/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Arrays;
import org.tensorflow.DataType;
import org.tensorflow.TensorFlow;

public final class Tensor
implements AutoCloseable {
    private long nativeHandle;
    private DataType dtype;
    private long[] shapeCopy = null;

    public static Tensor create(Object obj) {
        Tensor t = new Tensor();
        t.dtype = Tensor.dataTypeOf(obj);
        t.shapeCopy = new long[Tensor.numDimensions(obj)];
        Tensor.fillShape(obj, 0, t.shapeCopy);
        if (t.dtype != DataType.STRING) {
            int byteSize = Tensor.elemByteSize(t.dtype) * Tensor.numElements(t.shapeCopy);
            t.nativeHandle = Tensor.allocate(t.dtype.c(), t.shapeCopy, byteSize);
            Tensor.setValue(t.nativeHandle, obj);
        } else {
            if (t.shapeCopy.length != 0) {
                throw new UnsupportedOperationException(String.format("non-scalar DataType.STRING tensors are not supported yet (version %s). Please file a feature request at https://github.com/tensorflow/tensorflow/issues/new", TensorFlow.version()));
            }
            t.nativeHandle = Tensor.allocateScalarBytes((byte[])obj);
        }
        return t;
    }

    public static Tensor create(long[] shape, IntBuffer data) {
        Tensor t = Tensor.allocateForBuffer(DataType.INT32, shape, data.remaining());
        t.buffer().asIntBuffer().put(data);
        return t;
    }

    public static Tensor create(long[] shape, FloatBuffer data) {
        Tensor t = Tensor.allocateForBuffer(DataType.FLOAT, shape, data.remaining());
        t.buffer().asFloatBuffer().put(data);
        return t;
    }

    public static Tensor create(long[] shape, DoubleBuffer data) {
        Tensor t = Tensor.allocateForBuffer(DataType.DOUBLE, shape, data.remaining());
        t.buffer().asDoubleBuffer().put(data);
        return t;
    }

    public static Tensor create(long[] shape, LongBuffer data) {
        Tensor t = Tensor.allocateForBuffer(DataType.INT64, shape, data.remaining());
        t.buffer().asLongBuffer().put(data);
        return t;
    }

    public static Tensor create(DataType dataType, long[] shape, ByteBuffer data) {
        int nremaining = 0;
        if (dataType != DataType.STRING) {
            int elemBytes = Tensor.elemByteSize(dataType);
            if (data.remaining() % elemBytes != 0) {
                throw new IllegalArgumentException(String.format("ByteBuffer with %d bytes is not compatible with a %s Tensor (%d bytes/element)", data.remaining(), dataType.toString(), elemBytes));
            }
            nremaining = data.remaining() / elemBytes;
        } else {
            nremaining = data.remaining();
        }
        Tensor t = Tensor.allocateForBuffer(dataType, shape, nremaining);
        t.buffer().put(data);
        return t;
    }

    private static Tensor allocateForBuffer(DataType dataType, long[] shape, int nBuffered) {
        int nflattened = Tensor.numElements(shape);
        int nbytes = 0;
        if (dataType != DataType.STRING) {
            if (nBuffered != nflattened) {
                throw Tensor.incompatibleBuffer(nBuffered, shape);
            }
            nbytes = nflattened * Tensor.elemByteSize(dataType);
        } else {
            nbytes = nBuffered;
        }
        Tensor t = new Tensor();
        t.dtype = dataType;
        t.shapeCopy = Arrays.copyOf(shape, shape.length);
        t.nativeHandle = Tensor.allocate(t.dtype.c(), t.shapeCopy, nbytes);
        return t;
    }

    @Override
    public void close() {
        if (this.nativeHandle != 0L) {
            Tensor.delete(this.nativeHandle);
            this.nativeHandle = 0L;
        }
    }

    public DataType dataType() {
        return this.dtype;
    }

    public int numDimensions() {
        return this.shapeCopy.length;
    }

    public int numBytes() {
        return this.buffer().remaining();
    }

    public int numElements() {
        return Tensor.numElements(this.shapeCopy);
    }

    public long[] shape() {
        return this.shapeCopy;
    }

    public float floatValue() {
        return Tensor.scalarFloat(this.nativeHandle);
    }

    public double doubleValue() {
        return Tensor.scalarDouble(this.nativeHandle);
    }

    public int intValue() {
        return Tensor.scalarInt(this.nativeHandle);
    }

    public long longValue() {
        return Tensor.scalarLong(this.nativeHandle);
    }

    public boolean booleanValue() {
        return Tensor.scalarBoolean(this.nativeHandle);
    }

    public byte[] bytesValue() {
        return Tensor.scalarBytes(this.nativeHandle);
    }

    public <T> T copyTo(T dst) {
        this.throwExceptionIfTypeIsIncompatible(dst);
        Tensor.readNDArray(this.nativeHandle, dst);
        return dst;
    }

    public void writeTo(IntBuffer dst) {
        if (this.dtype != DataType.INT32) {
            throw Tensor.incompatibleBuffer(dst, this.dtype);
        }
        ByteBuffer src = this.buffer();
        dst.put(src.asIntBuffer());
    }

    public void writeTo(FloatBuffer dst) {
        if (this.dtype != DataType.FLOAT) {
            throw Tensor.incompatibleBuffer(dst, this.dtype);
        }
        ByteBuffer src = this.buffer();
        dst.put(src.asFloatBuffer());
    }

    public void writeTo(DoubleBuffer dst) {
        if (this.dtype != DataType.DOUBLE) {
            throw Tensor.incompatibleBuffer(dst, this.dtype);
        }
        ByteBuffer src = this.buffer();
        dst.put(src.asDoubleBuffer());
    }

    public void writeTo(LongBuffer dst) {
        if (this.dtype != DataType.INT64) {
            throw Tensor.incompatibleBuffer(dst, this.dtype);
        }
        ByteBuffer src = this.buffer();
        dst.put(src.asLongBuffer());
    }

    public void writeTo(ByteBuffer dst) {
        ByteBuffer src = this.buffer();
        dst.put(src);
    }

    public String toString() {
        return String.format("%s tensor with shape %s", this.dtype.toString(), Arrays.toString(this.shape()));
    }

    static Tensor fromHandle(long handle) {
        Tensor t = new Tensor();
        t.dtype = DataType.fromC(Tensor.dtype(handle));
        t.shapeCopy = Tensor.shape(handle);
        t.nativeHandle = handle;
        return t;
    }

    long getNativeHandle() {
        return this.nativeHandle;
    }

    private Tensor() {
    }

    private ByteBuffer buffer() {
        return Tensor.buffer(this.nativeHandle).order(ByteOrder.nativeOrder());
    }

    private static IllegalArgumentException incompatibleBuffer(Buffer buf, DataType dataType) {
        return new IllegalArgumentException(String.format("cannot use %s with Tensor of type %s", new Object[]{buf.getClass().getName(), dataType}));
    }

    private static IllegalArgumentException incompatibleBuffer(int numElements, long[] shape) {
        return new IllegalArgumentException(String.format("buffer with %d elements is not compatible with a Tensor with shape %s", numElements, Arrays.toString(shape)));
    }

    private static int numElements(long[] shape) {
        int n = 1;
        for (int i = 0; i < shape.length; ++i) {
            n *= (int)shape[i];
        }
        return n;
    }

    private static int elemByteSize(DataType dataType) {
        switch (dataType) {
            case UINT8: {
                return 1;
            }
            case FLOAT: 
            case INT32: {
                return 4;
            }
            case DOUBLE: 
            case INT64: {
                return 8;
            }
            case BOOL: {
                return 1;
            }
            case STRING: {
                throw new IllegalArgumentException("STRING tensors do not have a fixed element size");
            }
        }
        throw new IllegalArgumentException("DataType " + (Object)((Object)dataType) + " is not supported yet");
    }

    private static DataType dataTypeOf(Object o) {
        if (o.getClass().isArray()) {
            if (Array.getLength(o) == 0) {
                throw new IllegalArgumentException("cannot create Tensors with a 0 dimension");
            }
            Object e = Array.get(o, 0);
            if (Byte.class.isInstance(e) || Byte.TYPE.isInstance(e)) {
                return DataType.STRING;
            }
            return Tensor.dataTypeOf(e);
        }
        if (Float.class.isInstance(o) || Float.TYPE.isInstance(o)) {
            return DataType.FLOAT;
        }
        if (Double.class.isInstance(o) || Double.TYPE.isInstance(o)) {
            return DataType.DOUBLE;
        }
        if (Integer.class.isInstance(o) || Integer.TYPE.isInstance(o)) {
            return DataType.INT32;
        }
        if (Long.class.isInstance(o) || Long.TYPE.isInstance(o)) {
            return DataType.INT64;
        }
        if (Boolean.class.isInstance(o) || Boolean.TYPE.isInstance(o)) {
            return DataType.BOOL;
        }
        throw new IllegalArgumentException("cannot create Tensors of " + o.getClass().getName());
    }

    private static int numDimensions(Object o) {
        if (o.getClass().isArray()) {
            Object e = Array.get(o, 0);
            if (Byte.class.isInstance(e) || Byte.TYPE.isInstance(e)) {
                return 0;
            }
            return 1 + Tensor.numDimensions(e);
        }
        return 0;
    }

    private static void fillShape(Object o, int dim, long[] shape) {
        if (shape == null || dim == shape.length) {
            return;
        }
        int len = Array.getLength(o);
        if (shape[dim] == 0L) {
            shape[dim] = len;
        } else if (shape[dim] != (long)len) {
            throw new IllegalArgumentException(String.format("mismatched lengths (%d and %d) in dimension %d", shape[dim], len, dim));
        }
        for (int i = 0; i < len; ++i) {
            Tensor.fillShape(Array.get(o, i), dim + 1, shape);
        }
    }

    private void throwExceptionIfTypeIsIncompatible(Object o) {
        if (Tensor.numDimensions(o) != this.numDimensions()) {
            throw new IllegalArgumentException(String.format("cannot copy Tensor with %d dimensions into an object with %d", this.numDimensions(), Tensor.numDimensions(o)));
        }
        if (Tensor.dataTypeOf(o) != this.dtype) {
            throw new IllegalArgumentException(String.format("cannot copy Tensor with DataType %s into an object of type %s", this.dtype.toString(), o.getClass().getName()));
        }
        long[] oShape = new long[this.numDimensions()];
        Tensor.fillShape(o, 0, oShape);
        for (int i = 0; i < oShape.length; ++i) {
            if (oShape[i] == this.shape()[i]) continue;
            throw new IllegalArgumentException(String.format("cannot copy Tensor with shape %s into object with shape %s", Arrays.toString(this.shape()), Arrays.toString(oShape)));
        }
    }

    private static native long allocate(int var0, long[] var1, long var2);

    private static native long allocateScalarBytes(byte[] var0);

    private static native void delete(long var0);

    private static native ByteBuffer buffer(long var0);

    private static native int dtype(long var0);

    private static native long[] shape(long var0);

    private static native void setValue(long var0, Object var2);

    private static native float scalarFloat(long var0);

    private static native double scalarDouble(long var0);

    private static native int scalarInt(long var0);

    private static native long scalarLong(long var0);

    private static native boolean scalarBoolean(long var0);

    private static native byte[] scalarBytes(long var0);

    private static native void readNDArray(long var0, Object var2);

    static {
        TensorFlow.init();
    }
}

