/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.train;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SdcaOptimizer
extends PrimitiveOp {
    private Output<Float> outExampleStateData;
    private List<Output<Float>> outDeltaSparseWeights;
    private List<Output<Float>> outDeltaDenseWeights;

    public static SdcaOptimizer create(Scope scope, Iterable<Operand<Long>> sparseExampleIndices, Iterable<Operand<Long>> sparseFeatureIndices, Iterable<Operand<Float>> sparseFeatureValues, Iterable<Operand<Float>> denseFeatures, Operand<Float> exampleWeights, Operand<Float> exampleLabels, Iterable<Operand<Long>> sparseIndices, Iterable<Operand<Float>> sparseWeights, Iterable<Operand<Float>> denseWeights, Operand<Float> exampleStateData, String lossType, Float l1, Float l2, Long numLossPartitions, Long numInnerIterations, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("SdcaOptimizerV2", scope.makeOpName("SdcaOptimizer"));
        opBuilder.addInputList(Operands.asOutputs(sparseExampleIndices));
        opBuilder.addInputList(Operands.asOutputs(sparseFeatureIndices));
        opBuilder.addInputList(Operands.asOutputs(sparseFeatureValues));
        opBuilder.addInputList(Operands.asOutputs(denseFeatures));
        opBuilder.addInput(exampleWeights.asOutput());
        opBuilder.addInput(exampleLabels.asOutput());
        opBuilder.addInputList(Operands.asOutputs(sparseIndices));
        opBuilder.addInputList(Operands.asOutputs(sparseWeights));
        opBuilder.addInputList(Operands.asOutputs(denseWeights));
        opBuilder.addInput(exampleStateData.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("loss_type", lossType);
        opBuilder.setAttr("l1", l1.floatValue());
        opBuilder.setAttr("l2", l2.floatValue());
        opBuilder.setAttr("num_loss_partitions", numLossPartitions);
        opBuilder.setAttr("num_inner_iterations", numInnerIterations);
        if (options != null) {
            for (Options opts : options) {
                if (opts.adaptive == null) continue;
                opBuilder.setAttr("adaptive", opts.adaptive);
            }
        }
        return new SdcaOptimizer(opBuilder.build());
    }

    public static Options adaptive(Boolean adaptive) {
        return new Options().adaptive(adaptive);
    }

    public Output<Float> outExampleStateData() {
        return this.outExampleStateData;
    }

    public List<Output<Float>> outDeltaSparseWeights() {
        return this.outDeltaSparseWeights;
    }

    public List<Output<Float>> outDeltaDenseWeights() {
        return this.outDeltaDenseWeights;
    }

    private SdcaOptimizer(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.outExampleStateData = operation.output(outputIdx++);
        int outDeltaSparseWeightsLength = operation.outputListLength("out_delta_sparse_weights");
        this.outDeltaSparseWeights = Arrays.asList(operation.outputList(outputIdx, outDeltaSparseWeightsLength));
        int outDeltaDenseWeightsLength = operation.outputListLength("out_delta_dense_weights");
        this.outDeltaDenseWeights = Arrays.asList(operation.outputList(outputIdx += outDeltaSparseWeightsLength, outDeltaDenseWeightsLength));
        outputIdx += outDeltaDenseWeightsLength;
    }

    public static class Options {
        private Boolean adaptive;

        public Options adaptive(Boolean adaptive) {
            this.adaptive = adaptive;
            return this;
        }

        private Options() {
        }
    }
}

