/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.train;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class GenerateVocabRemapping
extends PrimitiveOp {
    private Output<Long> remapping;
    private Output<Integer> numPresent;

    public static GenerateVocabRemapping create(Scope scope, Operand<String> newVocabFile, Operand<String> oldVocabFile, Long newVocabOffset, Long numNewVocab, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("GenerateVocabRemapping", scope.makeOpName("GenerateVocabRemapping"));
        opBuilder.addInput(newVocabFile.asOutput());
        opBuilder.addInput(oldVocabFile.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("new_vocab_offset", newVocabOffset);
        opBuilder.setAttr("num_new_vocab", numNewVocab);
        if (options != null) {
            for (Options opts : options) {
                if (opts.oldVocabSize == null) continue;
                opBuilder.setAttr("old_vocab_size", opts.oldVocabSize);
            }
        }
        return new GenerateVocabRemapping(opBuilder.build());
    }

    public static Options oldVocabSize(Long oldVocabSize) {
        return new Options().oldVocabSize(oldVocabSize);
    }

    public Output<Long> remapping() {
        return this.remapping;
    }

    public Output<Integer> numPresent() {
        return this.numPresent;
    }

    private GenerateVocabRemapping(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.remapping = operation.output(outputIdx++);
        this.numPresent = operation.output(outputIdx++);
    }

    public static class Options {
        private Long oldVocabSize;

        public Options oldVocabSize(Long oldVocabSize) {
            this.oldVocabSize = oldVocabSize;
            return this;
        }

        private Options() {
        }
    }
}

