/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class DeserializeSparse<U>
extends PrimitiveOp {
    private Output<Long> sparseIndices;
    private Output<U> sparseValues;
    private Output<Long> sparseShape;

    public static <U, T> DeserializeSparse<U> create(Scope scope, Operand<T> serializedSparse, Class<U> dtype) {
        OperationBuilder opBuilder = scope.env().opBuilder("DeserializeSparse", scope.makeOpName("DeserializeSparse"));
        opBuilder.addInput(serializedSparse.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("dtype", DataType.fromClass(dtype));
        return new DeserializeSparse<U>(opBuilder.build());
    }

    public Output<Long> sparseIndices() {
        return this.sparseIndices;
    }

    public Output<U> sparseValues() {
        return this.sparseValues;
    }

    public Output<Long> sparseShape() {
        return this.sparseShape;
    }

    private DeserializeSparse(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.sparseIndices = operation.output(outputIdx++);
        this.sparseValues = operation.output(outputIdx++);
        this.sparseShape = operation.output(outputIdx++);
    }
}

