/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class TriangularSolve<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T> TriangularSolve<T> create(Scope scope, Operand<T> matrix, Operand<T> rhs, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("MatrixTriangularSolve", scope.makeOpName("TriangularSolve"));
        opBuilder.addInput(matrix.asOutput());
        opBuilder.addInput(rhs.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.lower != null) {
                    opBuilder.setAttr("lower", opts.lower);
                }
                if (opts.adjoint == null) continue;
                opBuilder.setAttr("adjoint", opts.adjoint);
            }
        }
        return new TriangularSolve<T>(opBuilder.build());
    }

    public static Options lower(Boolean lower) {
        return new Options().lower(lower);
    }

    public static Options adjoint(Boolean adjoint) {
        return new Options().adjoint(adjoint);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private TriangularSolve(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean lower;
        private Boolean adjoint;

        public Options lower(Boolean lower) {
            this.lower = lower;
            return this;
        }

        public Options adjoint(Boolean adjoint) {
            this.adjoint = adjoint;
            return this;
        }

        private Options() {
        }
    }
}

