/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedMatMul<V>
extends PrimitiveOp {
    private Output<V> out;
    private Output<Float> minOut;
    private Output<Float> maxOut;

    public static <V, T, U, W> QuantizedMatMul<V> create(Scope scope, Operand<T> a, Operand<U> b, Operand<Float> minA, Operand<Float> maxA, Operand<Float> minB, Operand<Float> maxB, Class<V> Toutput, Class<W> Tactivation, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("QuantizedMatMul", scope.makeOpName("QuantizedMatMul"));
        opBuilder.addInput(a.asOutput());
        opBuilder.addInput(b.asOutput());
        opBuilder.addInput(minA.asOutput());
        opBuilder.addInput(maxA.asOutput());
        opBuilder.addInput(minB.asOutput());
        opBuilder.addInput(maxB.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("Toutput", DataType.fromClass(Toutput));
        opBuilder.setAttr("Tactivation", DataType.fromClass(Tactivation));
        if (options != null) {
            for (Options opts : options) {
                if (opts.transposeA != null) {
                    opBuilder.setAttr("transpose_a", opts.transposeA);
                }
                if (opts.transposeB == null) continue;
                opBuilder.setAttr("transpose_b", opts.transposeB);
            }
        }
        return new QuantizedMatMul<V>(opBuilder.build());
    }

    public static Options transposeA(Boolean transposeA) {
        return new Options().transposeA(transposeA);
    }

    public static Options transposeB(Boolean transposeB) {
        return new Options().transposeB(transposeB);
    }

    public Output<V> out() {
        return this.out;
    }

    public Output<Float> minOut() {
        return this.minOut;
    }

    public Output<Float> maxOut() {
        return this.maxOut;
    }

    private QuantizedMatMul(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.out = operation.output(outputIdx++);
        this.minOut = operation.output(outputIdx++);
        this.maxOut = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean transposeA;
        private Boolean transposeB;

        public Options transposeA(Boolean transposeA) {
            this.transposeA = transposeA;
            return this;
        }

        public Options transposeB(Boolean transposeB) {
            this.transposeB = transposeB;
            return this;
        }

        private Options() {
        }
    }
}

