/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BatchMatMul<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T> BatchMatMul<T> create(Scope scope, Operand<T> x, Operand<T> y, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("BatchMatMul", scope.makeOpName("BatchMatMul"));
        opBuilder.addInput(x.asOutput());
        opBuilder.addInput(y.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.adjX != null) {
                    opBuilder.setAttr("adj_x", opts.adjX);
                }
                if (opts.adjY == null) continue;
                opBuilder.setAttr("adj_y", opts.adjY);
            }
        }
        return new BatchMatMul<T>(opBuilder.build());
    }

    public static Options adjX(Boolean adjX) {
        return new Options().adjX(adjX);
    }

    public static Options adjY(Boolean adjY) {
        return new Options().adjY(adjY);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private BatchMatMul(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean adjX;
        private Boolean adjY;

        public Options adjX(Boolean adjX) {
            this.adjX = adjX;
            return this;
        }

        public Options adjY(Boolean adjY) {
            this.adjY = adjY;
            return this;
        }

        private Options() {
        }
    }
}

