/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ParseSingleExample
extends PrimitiveOp {
    private List<Output<Long>> sparseIndices;
    private List<Output<?>> sparseValues;
    private List<Output<Long>> sparseShapes;
    private List<Output<?>> denseValues;

    public static ParseSingleExample create(Scope scope, Operand<String> serialized, Iterable<Operand<?>> denseDefaults, Long numSparse, List<String> sparseKeys, List<String> denseKeys, List<Class<?>> sparseTypes, List<Shape> denseShapes) {
        OperationBuilder opBuilder = scope.env().opBuilder("ParseSingleExample", scope.makeOpName("ParseSingleExample"));
        opBuilder.addInput(serialized.asOutput());
        opBuilder.addInputList(Operands.asOutputs(denseDefaults));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("num_sparse", numSparse);
        String[] sparseKeysArray = new String[sparseKeys.size()];
        for (int i = 0; i < sparseKeysArray.length; ++i) {
            sparseKeysArray[i] = sparseKeys.get(i);
        }
        opBuilder.setAttr("sparse_keys", sparseKeysArray);
        String[] denseKeysArray = new String[denseKeys.size()];
        for (int i = 0; i < denseKeysArray.length; ++i) {
            denseKeysArray[i] = denseKeys.get(i);
        }
        opBuilder.setAttr("dense_keys", denseKeysArray);
        DataType[] sparseTypesArray = new DataType[sparseTypes.size()];
        for (int i = 0; i < sparseTypesArray.length; ++i) {
            sparseTypesArray[i] = DataType.fromClass(sparseTypes.get(i));
        }
        opBuilder.setAttr("sparse_types", sparseTypesArray);
        Shape[] denseShapesArray = new Shape[denseShapes.size()];
        for (int i = 0; i < denseShapesArray.length; ++i) {
            denseShapesArray[i] = denseShapes.get(i);
        }
        opBuilder.setAttr("dense_shapes", denseShapesArray);
        return new ParseSingleExample(opBuilder.build());
    }

    public List<Output<Long>> sparseIndices() {
        return this.sparseIndices;
    }

    public List<Output<?>> sparseValues() {
        return this.sparseValues;
    }

    public List<Output<Long>> sparseShapes() {
        return this.sparseShapes;
    }

    public List<Output<?>> denseValues() {
        return this.denseValues;
    }

    private ParseSingleExample(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int sparseIndicesLength = operation.outputListLength("sparse_indices");
        this.sparseIndices = Arrays.asList(operation.outputList(outputIdx, sparseIndicesLength));
        int sparseValuesLength = operation.outputListLength("sparse_values");
        this.sparseValues = Arrays.asList(operation.outputList(outputIdx += sparseIndicesLength, sparseValuesLength));
        int sparseShapesLength = operation.outputListLength("sparse_shapes");
        this.sparseShapes = Arrays.asList(operation.outputList(outputIdx += sparseValuesLength, sparseShapesLength));
        int denseValuesLength = operation.outputListLength("dense_values");
        this.denseValues = Arrays.asList(operation.outputList(outputIdx += sparseShapesLength, denseValuesLength));
        outputIdx += denseValuesLength;
    }
}

