/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class PaddingFifoQueue
extends PrimitiveOp
implements Operand<Object> {
    private Output<?> handle;

    public static PaddingFifoQueue create(Scope scope, List<Class<?>> componentTypes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("PaddingFIFOQueueV2", scope.makeOpName("PaddingFifoQueue"));
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] componentTypesArray = new DataType[componentTypes.size()];
        for (int i = 0; i < componentTypesArray.length; ++i) {
            componentTypesArray[i] = DataType.fromClass(componentTypes.get(i));
        }
        opBuilder.setAttr("component_types", componentTypesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.shapes != null) {
                    Shape[] shapesArray = new Shape[opts.shapes.size()];
                    for (int i = 0; i < shapesArray.length; ++i) {
                        shapesArray[i] = (Shape)opts.shapes.get(i);
                    }
                    opBuilder.setAttr("shapes", shapesArray);
                }
                if (opts.capacity != null) {
                    opBuilder.setAttr("capacity", opts.capacity);
                }
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new PaddingFifoQueue(opBuilder.build());
    }

    public static Options shapes(List<Shape> shapes) {
        return new Options().shapes(shapes);
    }

    public static Options capacity(Long capacity) {
        return new Options().capacity(capacity);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<Object> asOutput() {
        return this.handle;
    }

    private PaddingFifoQueue(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private List<Shape> shapes;
        private Long capacity;
        private String container;
        private String sharedName;

        public Options shapes(List<Shape> shapes) {
            this.shapes = shapes;
            return this;
        }

        public Options capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        private Options() {
        }
    }
}

