/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class DeserializeManySparse<T>
extends PrimitiveOp {
    private Output<Long> sparseIndices;
    private Output<T> sparseValues;
    private Output<Long> sparseShape;

    public static <T> DeserializeManySparse<T> create(Scope scope, Operand<String> serializedSparse, Class<T> dtype) {
        OperationBuilder opBuilder = scope.env().opBuilder("DeserializeManySparse", scope.makeOpName("DeserializeManySparse"));
        opBuilder.addInput(serializedSparse.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("dtype", DataType.fromClass(dtype));
        return new DeserializeManySparse<T>(opBuilder.build());
    }

    public Output<Long> sparseIndices() {
        return this.sparseIndices;
    }

    public Output<T> sparseValues() {
        return this.sparseValues;
    }

    public Output<Long> sparseShape() {
        return this.sparseShape;
    }

    private DeserializeManySparse(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.sparseIndices = operation.output(outputIdx++);
        this.sparseValues = operation.output(outputIdx++);
        this.sparseShape = operation.output(outputIdx++);
    }
}

