/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.nio.ByteBuffer;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.op.Op;
import org.tensorflow.op.Scope;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.Fill;

public class Zeros<T>
implements Op,
Operand<T> {
    private final Fill<T> fill;

    public static <T, U extends Number> Zeros<T> create(Scope scope, Operand<U> dims, Class<T> type) {
        Scope childScope = scope.withSubScope("Zeros");
        int zeroSize = DataType.fromClass(type).byteSize();
        if (zeroSize < 0) {
            throw new IllegalArgumentException(type.getSimpleName() + " tensors cannot be initialized with zeros");
        }
        Constant<T> zero = Constant.create(childScope.withName("Zero"), type, new long[0], ByteBuffer.allocate(zeroSize));
        return new Zeros<T>(Fill.create(childScope, dims, zero));
    }

    @Override
    public Output<T> asOutput() {
        return this.fill.asOutput();
    }

    private Zeros(Fill<T> fill) {
        this.fill = fill;
    }
}

