/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class TensorListConcatV2<U>
extends PrimitiveOp {
    private Output<U> tensor;
    private Output<Long> lengths;

    public static <U, T extends Number> TensorListConcatV2<U> create(Scope scope, Operand<?> inputHandle, Operand<T> elementShape, Operand<Long> leadingDims, Class<U> elementDtype) {
        OperationBuilder opBuilder = scope.env().opBuilder("TensorListConcatV2", scope.makeOpName("TensorListConcatV2"));
        opBuilder.addInput(inputHandle.asOutput());
        opBuilder.addInput(elementShape.asOutput());
        opBuilder.addInput(leadingDims.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("element_dtype", DataType.fromClass(elementDtype));
        return new TensorListConcatV2<U>(opBuilder.build());
    }

    public Output<U> tensor() {
        return this.tensor;
    }

    public Output<Long> lengths() {
        return this.lengths;
    }

    private TensorListConcatV2(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.tensor = operation.output(outputIdx++);
        this.lengths = operation.output(outputIdx++);
    }
}

