/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ScaleAndTranslate
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> resizedImages;

    public static <T extends Number> ScaleAndTranslate create(Scope scope, Operand<T> images, Operand<Integer> size, Operand<Float> scale, Operand<Float> translation, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("ScaleAndTranslate", scope.makeOpName("ScaleAndTranslate"));
        opBuilder.addInput(images.asOutput());
        opBuilder.addInput(size.asOutput());
        opBuilder.addInput(scale.asOutput());
        opBuilder.addInput(translation.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.kernelType != null) {
                    opBuilder.setAttr("kernel_type", opts.kernelType);
                }
                if (opts.antialias == null) continue;
                opBuilder.setAttr("antialias", opts.antialias);
            }
        }
        return new ScaleAndTranslate(opBuilder.build());
    }

    public static Options kernelType(String kernelType) {
        return new Options().kernelType(kernelType);
    }

    public static Options antialias(Boolean antialias) {
        return new Options().antialias(antialias);
    }

    public Output<Float> resizedImages() {
        return this.resizedImages;
    }

    @Override
    public Output<Float> asOutput() {
        return this.resizedImages;
    }

    private ScaleAndTranslate(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.resizedImages = operation.output(outputIdx++);
    }

    public static class Options {
        private String kernelType;
        private Boolean antialias;

        public Options kernelType(String kernelType) {
            this.kernelType = kernelType;
            return this;
        }

        public Options antialias(Boolean antialias) {
            this.antialias = antialias;
            return this;
        }

        private Options() {
        }
    }
}

