/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BoostedTreesCalculateBestFeatureSplit
extends PrimitiveOp {
    private Output<Integer> nodeIds;
    private Output<Float> gains;
    private Output<Integer> featureDimensions;
    private Output<Integer> thresholds;
    private Output<Float> leftNodeContribs;
    private Output<Float> rightNodeContribs;
    private Output<String> splitWithDefaultDirections;

    public static BoostedTreesCalculateBestFeatureSplit create(Scope scope, Operand<Integer> nodeIdRange, Operand<Float> statsSummary, Operand<Float> l1, Operand<Float> l2, Operand<Float> treeComplexity, Operand<Float> minNodeWeight, Long logitsDimension, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("BoostedTreesCalculateBestFeatureSplit", scope.makeOpName("BoostedTreesCalculateBestFeatureSplit"));
        opBuilder.addInput(nodeIdRange.asOutput());
        opBuilder.addInput(statsSummary.asOutput());
        opBuilder.addInput(l1.asOutput());
        opBuilder.addInput(l2.asOutput());
        opBuilder.addInput(treeComplexity.asOutput());
        opBuilder.addInput(minNodeWeight.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("logits_dimension", logitsDimension);
        if (options != null) {
            for (Options opts : options) {
                if (opts.splitType == null) continue;
                opBuilder.setAttr("split_type", opts.splitType);
            }
        }
        return new BoostedTreesCalculateBestFeatureSplit(opBuilder.build());
    }

    public static Options splitType(String splitType) {
        return new Options().splitType(splitType);
    }

    public Output<Integer> nodeIds() {
        return this.nodeIds;
    }

    public Output<Float> gains() {
        return this.gains;
    }

    public Output<Integer> featureDimensions() {
        return this.featureDimensions;
    }

    public Output<Integer> thresholds() {
        return this.thresholds;
    }

    public Output<Float> leftNodeContribs() {
        return this.leftNodeContribs;
    }

    public Output<Float> rightNodeContribs() {
        return this.rightNodeContribs;
    }

    public Output<String> splitWithDefaultDirections() {
        return this.splitWithDefaultDirections;
    }

    private BoostedTreesCalculateBestFeatureSplit(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.nodeIds = operation.output(outputIdx++);
        this.gains = operation.output(outputIdx++);
        this.featureDimensions = operation.output(outputIdx++);
        this.thresholds = operation.output(outputIdx++);
        this.leftNodeContribs = operation.output(outputIdx++);
        this.rightNodeContribs = operation.output(outputIdx++);
        this.splitWithDefaultDirections = operation.output(outputIdx++);
    }

    public static class Options {
        private String splitType;

        public Options splitType(String splitType) {
            this.splitType = splitType;
            return this;
        }

        private Options() {
        }
    }
}

