/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class DecodeRaw<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> DecodeRaw<T> create(Scope scope, Operand<String> bytes, Class<T> outType, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("DecodeRaw", scope.makeOpName("DecodeRaw"));
        opBuilder.addInput(bytes.asOutput());
        opBuilder.setAttr("out_type", DataType.fromClass(outType));
        if (options != null) {
            for (Options opts : options) {
                if (opts.littleEndian == null) continue;
                opBuilder.setAttr("little_endian", opts.littleEndian);
            }
        }
        return new DecodeRaw<T>(opBuilder.build());
    }

    public static Options littleEndian(Boolean littleEndian) {
        return new Options().littleEndian(littleEndian);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private DecodeRaw(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean littleEndian;

        public Options littleEndian(Boolean littleEndian) {
            this.littleEndian = littleEndian;
            return this;
        }

        private Options() {
        }
    }
}

