/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Unstack<T>
extends PrimitiveOp
implements Iterable<Operand<T>> {
    private List<Output<T>> output;

    public static <T> Unstack<T> create(Scope scope, Operand<T> value, Long num, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("Unpack", scope.makeOpName("Unstack"));
        opBuilder.addInput(value.asOutput());
        opBuilder.setAttr("num", num);
        if (options != null) {
            for (Options opts : options) {
                if (opts.axis == null) continue;
                opBuilder.setAttr("axis", opts.axis);
            }
        }
        return new Unstack<T>(opBuilder.build());
    }

    public static Options axis(Long axis) {
        return new Options().axis(axis);
    }

    public List<Output<T>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<T>> iterator() {
        return this.output.iterator();
    }

    private Unstack(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }

    public static class Options {
        private Long axis;

        public Options axis(Long axis) {
            this.axis = axis;
            return this;
        }

        private Options() {
        }
    }
}

