/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class NonMaxSuppressionV4
extends PrimitiveOp {
    private Output<Integer> selectedIndices;
    private Output<Integer> validOutputs;

    public static <T extends Number> NonMaxSuppressionV4 create(Scope scope, Operand<T> boxes, Operand<T> scores, Operand<Integer> maxOutputSize, Operand<Float> iouThreshold, Operand<Float> scoreThreshold, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("NonMaxSuppressionV4", scope.makeOpName("NonMaxSuppressionV4"));
        opBuilder.addInput(boxes.asOutput());
        opBuilder.addInput(scores.asOutput());
        opBuilder.addInput(maxOutputSize.asOutput());
        opBuilder.addInput(iouThreshold.asOutput());
        opBuilder.addInput(scoreThreshold.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.padToMaxOutputSize == null) continue;
                opBuilder.setAttr("pad_to_max_output_size", opts.padToMaxOutputSize);
            }
        }
        return new NonMaxSuppressionV4(opBuilder.build());
    }

    public static Options padToMaxOutputSize(Boolean padToMaxOutputSize) {
        return new Options().padToMaxOutputSize(padToMaxOutputSize);
    }

    public Output<Integer> selectedIndices() {
        return this.selectedIndices;
    }

    public Output<Integer> validOutputs() {
        return this.validOutputs;
    }

    private NonMaxSuppressionV4(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.selectedIndices = operation.output(outputIdx++);
        this.validOutputs = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean padToMaxOutputSize;

        public Options padToMaxOutputSize(Boolean padToMaxOutputSize) {
            this.padToMaxOutputSize = padToMaxOutputSize;
            return this;
        }

        private Options() {
        }
    }
}

